/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.instance;

import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.instance.Instance;
import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.resources.Resources;

public class InstanceFactory {
    @Inject(optional=true)
    private Interceptor interceptor;
    private Map<Class, Instance> instances = new Hashtable<Class, Instance>();

    public List<Field> getDelegateFields(Class cls) {
        Instance instance = this.instances.get(cls);
        if (instance != null) {
            return instance.getDelegateFields();
        }
        return Instance.getDelegateFields(cls);
    }

    public <T> T newInstance(Resources resources, Class<T> implClass, Object ... delegates) {
        Instance instance;
        T inst = resources.newInstance(implClass);
        if (inst != null) {
            implClass = inst.getClass();
        }
        if ((instance = this.instances.get(implClass)) == null) {
            if (this.interceptor == null) {
                this.interceptor = Interceptor.getInstance();
            }
            instance = new Instance(implClass, this.interceptor);
            this.instances.put(implClass, instance);
        }
        return instance.newInstance(resources, delegates);
    }
}

