/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.inject;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import net.e6tech.elements.common.inject.Injector;
import net.e6tech.elements.common.inject.ModuleFactory;
import net.e6tech.elements.common.resources.BindClass;
import net.e6tech.elements.common.resources.BindProperties;

public interface Module {
    default public String[] getBindProperties(Class cls) {
        Objects.requireNonNull(cls);
        LinkedHashSet set = new LinkedHashSet();
        for (Class c = cls; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
            BindProperties annotation = c.getAnnotation(BindProperties.class);
            if (annotation == null) continue;
            Collections.addAll(set, annotation.value());
        }
        return set.toArray(new String[set.size()]);
    }

    default public Type[] getBindClass(Class<?> cls) {
        Objects.requireNonNull(cls);
        Class prev = cls;
        Class bindClass = cls;
        ArrayList<Type> list = new ArrayList<Type>();
        list.add(cls);
        boolean found = false;
        for (Class c = cls; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
            BindClass bind = c.getAnnotation(BindClass.class);
            if (bind != null) {
                if (bind.generics()) {
                    found = true;
                    list.add(prev.getGenericSuperclass());
                    break;
                }
                bindClass = bind.value();
                break;
            }
            prev = c;
        }
        if (!found) {
            if (bindClass.getGenericSuperclass() instanceof ParameterizedType && bindClass.getTypeParameters().length == 0 && bindClass.isAnonymousClass()) {
                list.add(bindClass.getGenericSuperclass());
            } else if (!bindClass.equals(cls)) {
                list.add(bindClass);
            }
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            if (!(type instanceof Class) || !((Class)type).isSynthetic()) continue;
            iterator.remove();
        }
        return list.toArray(new Type[list.size()]);
    }

    public ModuleFactory getFactory();

    public void add(Module var1);

    public void bindClass(Class var1, Class var2);

    public Class getBoundClass(Class var1);

    public Object bindInstance(Class var1, Object var2);

    public Object unbindInstance(Class var1);

    public <T> T getBoundInstance(Class<T> var1);

    public Object bindNamedInstance(Class var1, String var2, Object var3);

    public <T> T getBoundNamedInstance(Class<T> var1, String var2);

    public Injector build(Module ... var1);
}

