/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util;

import java.lang.reflect.Constructor;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.SystemException;

public interface Rethrowable {
    default public SystemException systemException(Throwable e) {
        return this.systemException(e.getMessage(), e);
    }

    default public SystemException systemException(String msg) {
        return this.systemException(msg, null);
    }

    default public SystemException systemException(String msg, Throwable th) {
        if (th == null) {
            return new SystemException(msg);
        }
        return new SystemException(msg, th);
    }

    default public <T extends Throwable> T exception(Class<T> exceptionClass, Throwable e) {
        return this.exception(exceptionClass, e.getMessage(), e);
    }

    default public <T extends Throwable> T exception(Class<T> exceptionClass, String msg, Throwable e) {
        Constructor<T> constructor = null;
        Throwable th = null;
        try {
            constructor = exceptionClass.getConstructor(Throwable.class);
            th = (Throwable)constructor.newInstance(e);
        }
        catch (Exception ex) {
            Logger.suppress(ex);
        }
        if (th == null) {
            try {
                constructor = exceptionClass.getConstructor(String.class);
                th = (Throwable)constructor.newInstance(msg);
            }
            catch (Exception ex) {
                Logger.suppress(ex);
            }
        }
        if (constructor == null) {
            try {
                constructor = exceptionClass.getConstructor(new Class[0]);
                th = (Throwable)constructor.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                Logger.suppress(ex);
            }
        }
        return (T)th;
    }
}

