/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.inject.spi;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.inject.Injector;
import net.e6tech.elements.common.inject.Named;
import net.e6tech.elements.common.inject.spi.Binding;
import net.e6tech.elements.common.inject.spi.ModuleImpl;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.util.SystemException;

public class InjectorImpl
implements Injector {
    private static Map<Class, WeakReference<List<InjectionPoint>>> injectionPoints = Collections.synchronizedMap(new WeakHashMap());
    private ModuleImpl module;
    private InjectorImpl parentInjector;
    private Map<Type, BoundInstances> instances = new HashMap<Type, BoundInstances>();

    public InjectorImpl(ModuleImpl module) {
        this.module = module;
    }

    public InjectorImpl(ModuleImpl module, InjectorImpl parentInjector) {
        this.module = module;
        this.parentInjector = parentInjector;
    }

    @Override
    public <T> T getInstance(Class<T> cls) {
        return this.getNamedInstance(cls, null);
    }

    @Override
    public <T> T getNamedInstance(Class<T> boundClass, String name) {
        return this.privateGetNamedInstance(boundClass, name).map(entry -> entry.value).orElse(null);
    }

    private Optional<Entry> privateGetNamedInstance(Type boundClass, String name) {
        BoundInstances boundInstances = this.instances.get(boundClass);
        Entry entry = null;
        if (boundInstances == null && boundClass instanceof ParameterizedType) {
            boundInstances = this.instances.get(((ParameterizedType)boundClass).getRawType());
        }
        if (boundInstances != null) {
            entry = boundInstances.getInstance(name);
        }
        if (entry == null) {
            Type type = boundClass;
            Binding binding = this.module.getBinding(type, name);
            if (binding == null && type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
                binding = this.module.getBinding(type, name);
            }
            if (binding != null) {
                if (boundInstances == null) {
                    boundInstances = new BoundInstances();
                    this.instances.put(type, boundInstances);
                }
                Object instance = null;
                if (binding.isSingleton()) {
                    instance = binding.getValue();
                } else {
                    try {
                        instance = binding.getImplementation().newInstance();
                    }
                    catch (Exception e) {
                        throw new SystemException(e);
                    }
                }
                entry = boundInstances.put(name, instance);
                if (!binding.isSingleton()) {
                    this.inject(instance);
                }
            } else if (this.parentInjector != null) {
                entry = this.parentInjector.privateGetNamedInstance(boundClass, name).orElse(null);
            }
        }
        return Optional.ofNullable(entry);
    }

    @Override
    public void inject(Object instance) {
        List<InjectionPoint> points;
        if (instance == null) {
            return;
        }
        Class<?> instanceClass = instance.getClass();
        WeakReference<List<InjectionPoint>> ref = injectionPoints.get(instanceClass);
        List<InjectionPoint> list = points = ref == null ? null : (List<InjectionPoint>)ref.get();
        if (points == null) {
            points = this.injectionProperties(instanceClass);
            points.addAll(this.injectionFields(instanceClass));
            injectionPoints.put(instanceClass, new WeakReference<List<InjectionPoint>>(points));
        }
        points.forEach(pt -> {
            boolean injected = this.inject((InjectionPoint)pt, instance);
            if (!injected) {
                throw new SystemException("Cannot inject " + pt + "; no instances bound to " + pt.getType());
            }
        });
    }

    protected boolean inject(InjectionPoint point, Object instance) {
        InjectionAttempt attempt = point.inject(this, instance);
        if (attempt == InjectionAttempt.INJECTED) {
            return true;
        }
        if (this.parentInjector != null) {
            return this.parentInjector.inject(point, instance);
        }
        return attempt != InjectionAttempt.ERROR;
    }

    private List<InjectionPoint> injectionFields(Class instanceClass) {
        ArrayList<InjectionPoint> list = new ArrayList<InjectionPoint>();
        for (Class cls = instanceClass; cls != Object.class; cls = cls.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                InjectionPoint injectionPoint = this.injectionPoint(field, () -> new InjectionField(field)).orElse(null);
                if (injectionPoint == null) continue;
                list.add(injectionPoint);
            }
        }
        return list;
    }

    private List<InjectionPoint> injectionProperties(Class instanceClass) {
        ArrayList<InjectionPoint> list = new ArrayList<InjectionPoint>();
        BeanInfo beanInfo = Reflection.getBeanInfo(instanceClass);
        for (PropertyDescriptor prop : beanInfo.getPropertyDescriptors()) {
            InjectionPoint injectionPoint = this.injectionPoint(prop.getWriteMethod(), () -> new InjectionMethod(prop.getWriteMethod())).orElseGet(() -> this.injectionPoint(prop.getReadMethod(), () -> new InjectionMethod(prop.getWriteMethod())).orElse(null));
            if (injectionPoint == null) continue;
            list.add(injectionPoint);
        }
        return list;
    }

    private Optional<InjectionPoint> injectionPoint(AccessibleObject accessibleObject, Supplier<InjectionPoint> supplier) {
        if (accessibleObject == null) {
            return Optional.empty();
        }
        Inject inject = accessibleObject.getDeclaredAnnotation(Inject.class);
        InjectionPoint injectionPoint = null;
        if (inject != null) {
            injectionPoint = supplier.get();
            injectionPoint.optional = inject.optional();
            injectionPoint.type = inject.type();
            injectionPoint.property = inject.property();
        } else {
            javax.inject.Inject jInject = accessibleObject.getDeclaredAnnotation(javax.inject.Inject.class);
            if (jInject != null) {
                injectionPoint = supplier.get();
                injectionPoint.optional = false;
            }
        }
        if (injectionPoint != null) {
            Named named = accessibleObject.getDeclaredAnnotation(Named.class);
            if (named != null) {
                injectionPoint.name = named.value();
            } else {
                javax.inject.Named jNamed = accessibleObject.getDeclaredAnnotation(javax.inject.Named.class);
                if (jNamed != null) {
                    injectionPoint.name = jNamed.value();
                }
            }
        }
        return Optional.ofNullable(injectionPoint);
    }

    private static class InjectionMethod
    extends InjectionPoint {
        private Method setter;

        InjectionMethod(Method setter) {
            this.setter = setter;
        }

        @Override
        InjectionAttempt inject(InjectorImpl injector, Object target) {
            Type t = this.getType();
            Optional opt = injector.privateGetNamedInstance(t, this.name);
            if (!opt.isPresent() && !this.optional) {
                return InjectionAttempt.ERROR;
            }
            if (opt.isPresent()) {
                try {
                    Object value = ((Entry)opt.get()).value;
                    if (this.property.length() > 0 && value != null) {
                        value = Reflection.getProperty(value, this.property);
                    }
                    this.setter.invoke(target, value);
                }
                catch (IllegalAccessException e) {
                    throw new SystemException(e);
                }
                catch (InvocationTargetException e) {
                    throw new SystemException(e.getTargetException());
                }
                return InjectionAttempt.INJECTED;
            }
            return InjectionAttempt.NOT_INJECTED;
        }

        @Override
        Type getType() {
            return this.type != Void.TYPE && this.type != Void.class ? this.type : this.setter.getGenericParameterTypes()[0];
        }

        public String toString() {
            return this.setter.toString();
        }
    }

    private static class InjectionField
    extends InjectionPoint {
        private Field field;

        InjectionField(Field field) {
            this.field = field;
            if (!Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
            }
        }

        @Override
        InjectionAttempt inject(InjectorImpl injector, Object target) {
            Type t = this.type != Void.TYPE ? this.type : this.field.getGenericType();
            Optional opt = injector.privateGetNamedInstance(t, this.name);
            if (!opt.isPresent() && !this.optional) {
                return InjectionAttempt.ERROR;
            }
            if (opt.isPresent()) {
                try {
                    Object value = ((Entry)opt.get()).value;
                    if (this.property.length() > 0 && value != null) {
                        value = Reflection.getProperty(value, this.property);
                    }
                    this.field.set(target, value);
                }
                catch (IllegalAccessException e) {
                    throw new SystemException(e);
                }
                return InjectionAttempt.INJECTED;
            }
            return InjectionAttempt.NOT_INJECTED;
        }

        @Override
        Type getType() {
            return this.type != Void.TYPE && this.type != Void.class ? this.type : this.field.getGenericType();
        }

        public String toString() {
            return this.field.toString();
        }
    }

    private static abstract class InjectionPoint {
        protected String name;
        protected boolean optional;
        protected Class type = Void.TYPE;
        protected String property = "";

        private InjectionPoint() {
        }

        abstract InjectionAttempt inject(InjectorImpl var1, Object var2);

        abstract Type getType();
    }

    private static enum InjectionAttempt {
        ERROR,
        INJECTED,
        NOT_INJECTED;

    }

    private static class Entry {
        Object value;

        Entry(Object value) {
            this.value = value;
        }

        Object value() {
            return this.value;
        }
    }

    private static class BoundInstances {
        Map<String, Entry> namedInstances = new HashMap<String, Entry>();
        Entry unnamedInstance;

        private BoundInstances() {
        }

        Entry getInstance(String name) {
            if (name == null) {
                return this.unnamedInstance;
            }
            return this.namedInstances.get(name);
        }

        Entry put(String name, Object instance) {
            Entry entry = new Entry(instance);
            if (name == null) {
                this.unnamedInstance = entry;
            } else {
                this.namedInstances.put(name, entry);
            }
            return entry;
        }
    }
}

