/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.reflection;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Primitives {
    private static final Map<String, Class> primitives = new HashMap<String, Class>();

    private Primitives() {
    }

    public static boolean isPrimitive(String name) {
        return primitives.containsKey(name);
    }

    public static boolean isPrimitive(Class cls) {
        return primitives.containsKey(cls.getName());
    }

    public static Class get(String name) {
        return primitives.get(name);
    }

    public static Object defaultValue(Class cls) {
        if (Primitives.isPrimitive(cls)) {
            if (cls == Boolean.TYPE) {
                return false;
            }
            if (cls == Byte.TYPE) {
                return (byte)0;
            }
            if (cls == Character.TYPE) {
                return Character.valueOf('\u0000');
            }
            if (cls == Double.TYPE) {
                return 0.0;
            }
            if (cls == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (cls == Integer.TYPE) {
                return 0;
            }
            if (cls == Long.TYPE) {
                return 0L;
            }
            if (cls == Short.TYPE) {
                return (short)0;
            }
        } else {
            if (cls == Boolean.class) {
                return false;
            }
            if (cls == Byte.class) {
                return (byte)0;
            }
            if (cls == Character.class) {
                return Character.valueOf('\u0000');
            }
            if (cls == Double.class) {
                return 0.0;
            }
            if (cls == Float.class) {
                return Float.valueOf(0.0f);
            }
            if (cls == Integer.class) {
                return 0;
            }
            if (cls == Long.class) {
                return 0L;
            }
            if (cls == Short.class) {
                return (short)0;
            }
        }
        return null;
    }

    public static int hashCode(Object value) {
        if (value == null) {
            return 0;
        }
        Class<?> cls = value.getClass();
        if (!cls.isArray()) {
            return value.hashCode();
        }
        if (cls == boolean[].class) {
            return Arrays.hashCode((boolean[])value);
        }
        if (cls == byte[].class) {
            return Arrays.hashCode((byte[])value);
        }
        if (cls == char[].class) {
            return Arrays.hashCode((char[])value);
        }
        if (cls == double[].class) {
            return Arrays.hashCode((double[])value);
        }
        if (cls == float[].class) {
            return Arrays.hashCode((float[])value);
        }
        if (cls == int[].class) {
            return Arrays.hashCode((int[])value);
        }
        if (cls == long[].class) {
            return Arrays.hashCode((long[])value);
        }
        if (cls == short[].class) {
            return Arrays.hashCode((short[])value);
        }
        return Arrays.hashCode((Object[])value);
    }

    public static boolean equals(Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        Class<?> cls = value1.getClass();
        if (!cls.isArray()) {
            return value1.equals(value2);
        }
        if (value2.getClass() != cls) {
            return false;
        }
        if (cls == boolean[].class) {
            return Arrays.equals((boolean[])value1, (boolean[])value2);
        }
        if (cls == byte[].class) {
            return Arrays.equals((byte[])value1, (byte[])value2);
        }
        if (cls == char[].class) {
            return Arrays.equals((char[])value1, (char[])value2);
        }
        if (cls == double[].class) {
            return Arrays.equals((double[])value1, (double[])value2);
        }
        if (cls == float[].class) {
            return Arrays.equals((float[])value1, (float[])value2);
        }
        if (cls == int[].class) {
            return Arrays.equals((int[])value1, (int[])value2);
        }
        if (cls == long[].class) {
            return Arrays.equals((long[])value1, (long[])value2);
        }
        if (cls == short[].class) {
            return Arrays.equals((short[])value1, (short[])value2);
        }
        return Arrays.equals((Object[])value1, (Object[])value2);
    }

    public static String toString(Object value) {
        if (value == null) {
            return "null";
        }
        Class<?> cls = value.getClass();
        if (!cls.isArray()) {
            return value.toString();
        }
        if (cls == boolean[].class) {
            return Arrays.toString((boolean[])value);
        }
        if (cls == byte[].class) {
            return Arrays.toString((byte[])value);
        }
        if (cls == char[].class) {
            return Arrays.toString((char[])value);
        }
        if (cls == double[].class) {
            return Arrays.toString((double[])value);
        }
        if (cls == float[].class) {
            return Arrays.toString((float[])value);
        }
        if (cls == int[].class) {
            return Arrays.toString((int[])value);
        }
        if (cls == long[].class) {
            return Arrays.toString((long[])value);
        }
        if (cls == short[].class) {
            return Arrays.toString((short[])value);
        }
        return Arrays.toString((Object[])value);
    }

    static {
        primitives.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primitives.put(Byte.TYPE.getName(), Byte.TYPE);
        primitives.put(Character.TYPE.getName(), Character.TYPE);
        primitives.put(Double.TYPE.getName(), Double.TYPE);
        primitives.put(Float.TYPE.getName(), Float.TYPE);
        primitives.put(Integer.TYPE.getName(), Integer.TYPE);
        primitives.put(Long.TYPE.getName(), Long.TYPE);
        primitives.put(Short.TYPE.getName(), Short.TYPE);
    }
}

