/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.logging;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.e6tech.elements.common.logging.ExceptionLogger;
import net.e6tech.elements.common.logging.LogLevel;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.logging.NullLogger;
import net.e6tech.elements.common.util.Rethrowable;
import net.e6tech.elements.common.util.SystemException;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class LogHandler
implements InvocationHandler {
    private static final String LOG_DIR = "logDir";
    private static String logDir;
    private static ConsoleLogger consoleLogger;
    private org.slf4j.Logger slf4jLogger;
    private Class loggingClass;
    private String loggingName;
    private LogLevel level = LogLevel.ERROR;
    private ExceptionLogger exceptionLogger = new ExceptionLogger(){

        @Override
        public Logger exceptionLogger(LogLevel level) {
            LogHandler handler = new LogHandler(LogHandler.this.slf4jLogger);
            handler.level = level;
            return (Logger)Proxy.newProxyInstance(Logger.class.getClassLoader(), new Class[]{Logger.class}, (InvocationHandler)handler);
        }
    };
    private Rethrowable rethrowable = new Rethrowable(){

        @Override
        public SystemException systemException(String msg, Throwable th) {
            SystemException t = Rethrowable.super.systemException(msg, th);
            this.log(msg, th);
            return t;
        }

        @Override
        public <T extends Throwable> T exception(Class<T> exceptionClass, String msg, Throwable e) {
            T t = Rethrowable.super.exception(exceptionClass, msg, e);
            this.log(msg, e);
            return t;
        }

        protected void log(String msg, Throwable e) {
            if (LogHandler.this.getLogger() != null) {
                switch (LogHandler.this.level) {
                    case FATAL: 
                    case ERROR: {
                        LogHandler.this.getLogger().error(msg, e);
                        break;
                    }
                    case WARN: {
                        LogHandler.this.getLogger().warn(msg, e);
                        break;
                    }
                    case INFO: {
                        LogHandler.this.getLogger().info(msg, e);
                        break;
                    }
                    case DEBUG: {
                        LogHandler.this.getLogger().debug(msg, e);
                        break;
                    }
                    case TRACE: {
                        LogHandler.this.getLogger().trace(msg, e);
                        break;
                    }
                    default: {
                        LogHandler.this.getLogger().warn(msg, e);
                        break;
                    }
                }
            } else {
                System.out.println(msg);
                e.printStackTrace(System.out);
            }
        }
    };

    public LogHandler(org.slf4j.Logger slf4jLogger) {
        this.slf4jLogger = slf4jLogger;
    }

    public LogHandler(Class cls) {
        this.loggingClass = cls;
    }

    public LogHandler(String name) {
        this.loggingName = name;
    }

    protected org.slf4j.Logger getLogger() {
        if (this.slf4jLogger != null) {
            return this.slf4jLogger;
        }
        if (this.loggingClass == null && this.slf4jLogger == null && this.loggingName == null) {
            return null;
        }
        if (System.getProperty("log4j.configurationFile") == null) {
            return consoleLogger;
        }
        if (ThreadContext.get((String)LOG_DIR) == null) {
            if (logDir == null) {
                if (System.getProperty(LOG_DIR) != null) {
                    logDir = System.getProperty(LOG_DIR);
                } else if (System.getProperty("elements.common.logging.logDir") != null) {
                    logDir = System.getProperty("elements.common.logging.logDir");
                }
            }
            if (logDir == null) {
                return consoleLogger;
            }
            ThreadContext.put((String)LOG_DIR, (String)logDir);
        }
        if (this.loggingClass != null) {
            this.slf4jLogger = LoggerFactory.getLogger((Class)this.loggingClass);
        } else if (this.loggingName != null) {
            this.slf4jLogger = LoggerFactory.getLogger((String)this.loggingName);
        }
        this.loggingClass = null;
        this.loggingName = null;
        return this.slf4jLogger;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(Rethrowable.class)) {
            return method.invoke((Object)this.rethrowable, args);
        }
        if (method.getDeclaringClass().equals(ExceptionLogger.class)) {
            return method.invoke((Object)this.exceptionLogger, args);
        }
        org.slf4j.Logger logger = this.getLogger();
        if (logger == null) {
            return null;
        }
        return method.invoke((Object)logger, args);
    }

    static {
        System.setProperty("java.util.logging.manager", "net.e6tech.elements.common.logging.jul.LogManager");
        consoleLogger = new ConsoleLogger();
    }

    private static class ConsoleLogger
    extends NullLogger {
        private ConsoleLogger() {
        }

        @Override
        public String getName() {
            return "ConsoleLogger";
        }

        @Override
        public void info(String format, Object ... arguments) {
            if (arguments != null && arguments.length > 0) {
                System.out.println(MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage());
            } else {
                System.out.println(format);
            }
        }

        @Override
        public void info(String msg, Throwable t) {
            System.out.println(msg);
            if (t != null) {
                t.printStackTrace(System.out);
                System.out.println();
            }
        }
    }
}

