/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.inject.Module;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.resources.AfterCommit;
import net.e6tech.elements.common.resources.BindClass;
import net.e6tech.elements.common.resources.Binding;
import net.e6tech.elements.common.resources.Configurator;
import net.e6tech.elements.common.resources.Injectable;
import net.e6tech.elements.common.resources.InstanceNotFoundException;
import net.e6tech.elements.common.resources.OnAbort;
import net.e6tech.elements.common.resources.OnClosed;
import net.e6tech.elements.common.resources.OnCommit;
import net.e6tech.elements.common.resources.OnOpen;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.resources.ResourcePool;
import net.e6tech.elements.common.resources.ResourceProvider;
import net.e6tech.elements.common.resources.ResourcesState;
import net.e6tech.elements.common.resources.Retry;
import net.e6tech.elements.common.resources.Transactional;
import net.e6tech.elements.common.resources.plugin.Plugin;
import net.e6tech.elements.common.resources.plugin.PluginManager;
import net.e6tech.elements.common.resources.plugin.PluginPath;
import net.e6tech.elements.common.resources.plugin.PluginPaths;
import net.e6tech.elements.common.util.ExceptionMapper;
import net.e6tech.elements.common.util.SystemException;

@BindClass(value=Resources.class)
public class Resources
implements AutoCloseable,
ResourcePool {
    private static Logger logger = Logger.getLogger(Resources.class);
    private static final String ABORT_DUE_TO_EXCEPTION = "Aborting due to exception";
    private ResourceManager resourceManager;
    @Inject(optional=true)
    private Retry retry;
    protected ResourcesState state;
    protected Configurator configurator = new Configurator();
    protected Configurator initialConfigurator;
    private Consumer<? extends Resources> preOpen;
    private List<Replay<? extends Resources, ?>> replays = new LinkedList();
    Object lastResult;
    boolean submitting = false;

    protected Resources(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.state = new ResourcesState(this);
        this.getModule().bindInstance(this.getClass(), this);
    }

    void setPreOpen(Consumer<? extends Resources> preOpen) {
        this.preOpen = preOpen;
    }

    public synchronized boolean isCommitted() {
        return this.state.getState() == ResourcesState.State.COMMITTED;
    }

    public synchronized boolean isOpen() {
        return this.state.getState() == ResourcesState.State.OPEN;
    }

    public synchronized boolean isAborted() {
        return this.state.getState() == ResourcesState.State.ABORTED;
    }

    public synchronized boolean isClosed() {
        return !this.isOpen();
    }

    public synchronized boolean isDiscarded() {
        return this.resourceManager == null;
    }

    List<ResourceProvider> getExternalResourceProviders() {
        return this.state.getExternalResourceProviders();
    }

    void setExternalResourceProviders(List<ResourceProvider> externalResourceProviders) {
        this.state.setExternalResourceProviders(externalResourceProviders);
    }

    private List<ResourceProvider> getResourceProviders() {
        return this.state.getResourceProviders();
    }

    public synchronized void addResourceProvider(ResourceProvider resourceProvider) {
        this.getResourceProviders().add(resourceProvider);
        if (this.isOpen()) {
            resourceProvider.onOpen(this);
        }
        if (this.isCommitted()) {
            resourceProvider.onCommit(this);
        }
        if (this.isCommitted()) {
            resourceProvider.afterCommit(this);
        }
        if (this.isAborted()) {
            resourceProvider.onAbort(this);
        }
    }

    public void onCommit(OnCommit onCommit) {
        this.addResourceProvider(onCommit);
    }

    public void onCommit(Runnable runnable) {
        OnCommit on = res -> runnable.run();
        this.onCommit(on);
    }

    public void afterCommit(AfterCommit afterCommit) {
        this.addResourceProvider(afterCommit);
    }

    public void afterCommit(Runnable runnable) {
        AfterCommit after = res -> runnable.run();
        this.afterCommit(after);
    }

    public synchronized void onOpen(OnOpen onOpen) {
        this.addResourceProvider(onOpen);
    }

    public synchronized void onOpen(Runnable runnable) {
        OnOpen on = res -> runnable.run();
        this.onOpen(on);
    }

    public synchronized void onAbort(OnAbort onAbort) {
        this.addResourceProvider(onAbort);
    }

    public synchronized void onAbort(Runnable runnable) {
        OnAbort on = res -> runnable.run();
        this.onAbort(on);
    }

    public synchronized void onClosed(OnClosed onClosed) {
        this.addResourceProvider(onClosed);
    }

    public synchronized void onClosed(Runnable runnable) {
        OnClosed on = res -> runnable.run();
        this.onClosed(on);
    }

    public synchronized boolean remove(ResourceProvider provider) {
        return this.getResourceProviders().remove(provider);
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public <S, T extends Plugin> Optional<T> getPlugin(Class<S> c1, String n1, Class<T> c2, Object ... args) {
        return this.getPlugin(PluginPath.of(c1, n1).and(c2), args);
    }

    public <R, S, T extends Plugin> Optional<T> getPlugin(Class<R> c1, String n1, Class<S> c2, String n2, Class<T> c3, Object ... args) {
        return this.getPlugin(PluginPath.of(c1, n1).and(c2, n2).and(c3), args);
    }

    public <T extends Plugin> Optional<T> getPlugin(PluginPath<T> path, Object ... args) {
        PluginManager plugin = this.getInstance(PluginManager.class);
        return plugin.from(this).get(path, args);
    }

    public <T extends Plugin> Optional<T> getPlugin(PluginPaths<T> paths, Object ... args) {
        PluginManager plugin = this.getInstance(PluginManager.class);
        return plugin.from(this).get(paths, args);
    }

    public <T> T getVariable(String variable) {
        return this.resourceManager.getVariable(variable);
    }

    public Module getModule() {
        return this.state.getModule();
    }

    public void addModule(Module module) {
        this.state.addModule(module);
    }

    public <T> Binding<T> getBinding(Class<T> cls) {
        return new Binding<T>(this, cls);
    }

    public <T> T tryBind(Class<T> cls, Callable<T> callable) {
        return this.state.tryBind(cls, callable);
    }

    public <T> boolean isBound(Class<T> cls) {
        return this.getModule().getBoundInstance(cls) != null;
    }

    @Override
    public <T> T bind(Class<T> cls, T resource) {
        return this.state.bind(cls, resource);
    }

    @Override
    public <T> T rebind(Class<T> cls, T resource) {
        return this.state.rebind(cls, resource);
    }

    @Override
    public <T> T unbind(Class<T> cls) {
        return this.state.unbind(cls);
    }

    @Override
    public void bindClass(Class cls, Class service) {
        this.state.bindClass(cls, service);
    }

    @Override
    public <T> T bindNamedInstance(Class<T> cls, String name, T resource) {
        return this.state.bindNamedInstance(cls, name, resource);
    }

    @Override
    public <T> T rebindNamedInstance(Class<T> cls, String name, T resource) {
        return this.state.rebindNamedInstance(cls, name, resource);
    }

    public <T> T getNamedInstance(Class<T> cls, String name) {
        return this.getModule().getBoundNamedInstance(cls, name);
    }

    @Override
    public <T> T inject(T object) {
        return this.inject(object, new HashSet<Integer>());
    }

    private <T> T inject(T object, Set<Integer> seen) {
        if (object == null) {
            return null;
        }
        if (seen.contains(System.identityHashCode(object))) {
            return object;
        }
        T injected = this.state.inject(this, object);
        seen.add(System.identityHashCode(object));
        ResourceManager.ClassInjectionInfo info = this.resourceManager.getInjections().get(object.getClass());
        if (info == null) {
            info = new ResourceManager.ClassInjectionInfo();
            Class<?> cls = object.getClass();
            Package p = cls.getPackage();
            if (p == null || !p.getName().startsWith("java.") && !p.getName().startsWith("javax.")) {
                while (cls != null && !cls.equals(Object.class)) {
                    for (Field f : cls.getDeclaredFields()) {
                        if (f.getAnnotation(Injectable.class) == null && f.getType().getAnnotation(Injectable.class) == null) continue;
                        f.setAccessible(true);
                        info.addInjectableField(f);
                    }
                    cls = cls.getSuperclass();
                }
            }
            this.resourceManager.getInjections().put(object.getClass(), info);
        }
        for (Field f : info.getInjectableFields()) {
            try {
                Object injectField = f.get(object);
                if (injectField == null) continue;
                this.inject(injectField, seen);
            }
            catch (IllegalAccessException e) {
                throw new SystemException(e);
            }
        }
        return injected;
    }

    public boolean hasInstance(Class cls) {
        return this.state.hasInstance(this, cls);
    }

    public <T> T getInstance(Class<T> cls) {
        return this.state.getInstance(this, cls);
    }

    public <T> T getInstance(Class<T> cls, Supplier<T> call) {
        try {
            return this.state.getInstance(this, cls);
        }
        catch (InstanceNotFoundException ex) {
            Logger.suppress(ex);
            return call.get();
        }
    }

    public Configurator configurator() {
        return this.configurator;
    }

    public void configure(Configurator configurator) {
        this.configurator.putAll(configurator);
        if (this.initialConfigurator == null) {
            this.initialConfigurator = new Configurator();
        }
        this.initialConfigurator.putAll(configurator);
    }

    public synchronized void onOpen() {
        if (!this.isOpen()) {
            this.state.setState(ResourcesState.State.OPEN);
            try {
                for (ResourceProvider resourceProvider : this.state.getResourceProviders()) {
                    resourceProvider.onOpen(this);
                }
                this.state.onOpen(this);
                for (ResourceProvider p : this.getExternalResourceProviders()) {
                    p.afterOpen(this);
                }
                for (ResourceProvider resourceProvider : this.state.getResourceProviders()) {
                    resourceProvider.afterOpen(this);
                }
            }
            catch (Exception ex) {
                this.abort();
                throw ex;
            }
        }
    }

    protected <T extends Resources, R> R replay(Exception th, Replay<T, R> replay) {
        if (this.isAborted() || this.retry == null) {
            this.log(ABORT_DUE_TO_EXCEPTION, th);
            if (!this.isAborted()) {
                this.abort();
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new SystemException(th);
        }
        try {
            return (R)this.retry.retry(th, () -> {
                StringBuilder builder = new StringBuilder();
                builder.append("Resources retrying due to error: ").append(ExceptionMapper.unwrap(th).getClass()).append(", message: ").append(th.getMessage());
                Reflection.printStackTrace(builder, "    ", 2, 8);
                logger.warn(builder.toString());
                try {
                    this.abort();
                }
                catch (Exception th2) {
                    Logger.suppress(th2);
                }
                Resources retryResources = this.resourceManager.open(this.initialConfigurator, this.preOpen);
                this.state = retryResources.state;
                Iterator<Replay<Resources, ?>> iterator = this.replays.iterator();
                while (iterator.hasNext()) {
                    Object ret = iterator.next().replay(this);
                    if (iterator.hasNext()) continue;
                    this.lastResult = ret;
                }
                return replay.replay(this);
            });
        }
        catch (RuntimeException th2) {
            this.log(ABORT_DUE_TO_EXCEPTION, th2);
            this.abort();
            throw th2;
        }
        catch (Throwable th2) {
            this.log(ABORT_DUE_TO_EXCEPTION, th2);
            this.abort();
            throw new SystemException(th2);
        }
    }

    public synchronized <R extends Resources> void submit(Transactional.ConsumerWithException<R> work) {
        this.play(new Replay(work));
    }

    public synchronized <T extends Resources, R> R submit(Transactional.FunctionWithException<T, R> work) {
        return this.play(new Replay<T, R>(work));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Resources, R> R play(Replay<T, R> replay) {
        R ret = null;
        boolean topLevel = !this.submitting;
        this.submitting = true;
        try {
            try {
                ret = replay.replay(this);
            }
            catch (Exception th) {
                ret = this.replay(th, replay);
            }
            this.lastResult = ret;
        }
        finally {
            if (topLevel) {
                this.submitting = false;
                if (!this.isAborted()) {
                    this.replays.add(replay);
                }
            }
        }
        return ret;
    }

    private void log(String msg, Throwable th) {
        Provision provision = this.resourceManager.getInstance(Provision.class);
        provision.log(logger, msg, th);
    }

    public synchronized <R> R commit() {
        Object ret = null;
        try {
            ret = this._commit();
        }
        catch (Exception th) {
            ret = this.replay(th, new Replay<Resources, Object>(res -> this._commit()));
        }
        finally {
            if (this.isCommitted()) {
                this.cleanup();
                this.state.setState(ResourcesState.State.COMMITTED);
            }
        }
        return (R)ret;
    }

    private <R> R _commit() {
        ResourceProvider resourceProvider;
        Object ret = null;
        if (this.resourceManager == null) {
            return null;
        }
        if (this.isAborted()) {
            return (R)this.lastResult;
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Already closed");
        }
        for (int i = 0; i < this.state.getResourceProviders().size(); ++i) {
            resourceProvider = this.state.getResourceProviders().get(i);
            resourceProvider.onCommit(this);
            if (!this.isAborted()) continue;
            return (R)this.lastResult;
        }
        for (ResourceProvider p : this.getExternalResourceProviders()) {
            p.onCommit(this);
        }
        for (int i = 0; i < this.state.getResourceProviders().size(); ++i) {
            resourceProvider = this.state.getResourceProviders().get(i);
            try {
                resourceProvider.afterCommit(this);
                continue;
            }
            catch (Exception th) {
                Logger.suppress(th);
            }
        }
        this.state.setState(ResourcesState.State.COMMITTED);
        ret = this.lastResult;
        return (R)ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void abort() {
        try {
            if (this.resourceManager == null) {
                return;
            }
            if (!this.isAborted()) {
                for (int i = 0; i < this.state.getResourceProviders().size(); ++i) {
                    ResourceProvider resourceProvider = this.state.getResourceProviders().get(i);
                    try {
                        resourceProvider.onAbort(this);
                        continue;
                    }
                    catch (Exception th) {
                        Logger.suppress(th);
                    }
                }
                for (ResourceProvider p : this.getExternalResourceProviders()) {
                    try {
                        p.onAbort(this);
                    }
                    catch (Exception th) {
                        Logger.suppress(th);
                    }
                }
            }
        }
        finally {
            this.cleanup();
            this.state.setState(ResourcesState.State.ABORTED);
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.isOpen()) {
            return;
        }
        if (!this.isAborted()) {
            this.commit();
        } else {
            this.abort();
        }
    }

    protected void cleanup() {
        try {
            for (ResourceProvider resourceProvider : this.state.getResourceProviders()) {
                resourceProvider.onClosed(this);
            }
            for (ResourceProvider p : this.getExternalResourceProviders()) {
                p.onClosed(this);
            }
        }
        catch (Exception ex) {
            logger.trace(ex.getMessage(), ex);
        }
        this.state.cleanup();
        this.configurator.clear();
        this.replays.clear();
        this.lastResult = null;
        this.submitting = false;
        this.preOpen = null;
    }

    public <T extends Provision> T provision() {
        return (T)this.getInstance(Provision.class);
    }

    private static class Replay<T, R> {
        Transactional.ConsumerWithException<T> consumer;
        Transactional.FunctionWithException<T, R> function;

        Replay(Transactional.ConsumerWithException<T> work) {
            this.consumer = work;
        }

        Replay(Transactional.FunctionWithException<T, R> work) {
            this.function = work;
        }

        R replay(T res) throws Exception {
            if (this.consumer != null) {
                this.consumer.accept(res);
                return null;
            }
            return this.function.apply(res);
        }
    }
}

