/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.InstanceNotFoundException;
import net.e6tech.elements.common.resources.Resources;

public class Binding<T> {
    private Resources resources;
    private String name;
    private boolean oldValueExists;
    private Class<T> boundClass;
    private T oldValue;
    private T currentValue;

    public Binding(Class<T> boundClass, T value) {
        this.boundClass = boundClass;
        this.currentValue = value;
        this.oldValue = value;
    }

    public Binding(String name, Class<T> boundClass, T value) {
        this.name = name;
        this.boundClass = boundClass;
        this.currentValue = value;
        this.oldValue = value;
    }

    public Binding(Resources resources, Class<T> boundClass) {
        this.resources = resources;
        this.boundClass = boundClass;
        try {
            this.oldValue = resources.getInstance(boundClass);
            this.oldValueExists = true;
        }
        catch (InstanceNotFoundException ex) {
            Logger.suppress(ex);
            this.oldValueExists = false;
        }
        this.currentValue = this.oldValue;
    }

    public boolean isNotNull() {
        return this.currentValue != null;
    }

    public T get() {
        return this.currentValue;
    }

    public T rebind(T newValue) {
        this.currentValue = this.resources.rebind(this.boundClass, newValue);
        return this.currentValue;
    }

    public T restore() {
        if (this.oldValueExists) {
            return this.resources.rebind(this.boundClass, this.oldValue);
        }
        return this.resources.unbind(this.boundClass);
    }

    public String getName() {
        return this.name;
    }

    public Class getBoundClass() {
        return this.boundClass;
    }
}

