/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.inject.spi;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.e6tech.elements.common.inject.Injector;
import net.e6tech.elements.common.inject.Module;
import net.e6tech.elements.common.inject.ModuleFactory;
import net.e6tech.elements.common.inject.spi.Binding;
import net.e6tech.elements.common.inject.spi.InjectorImpl;
import net.e6tech.elements.common.util.SystemException;

public class ModuleImpl
implements Module {
    private ModuleFactory factory;
    private Map<Type, BindingList> directory = new HashMap<Type, BindingList>();

    public ModuleImpl(ModuleFactory factory) {
        this.factory = factory;
    }

    public Binding getBinding(Type boundClass, String name) {
        BindingList bindingList = this.directory.get(boundClass);
        if (bindingList == null) {
            return null;
        }
        Binding binding = bindingList.getBinding(name);
        binding = binding == null ? null : new Binding(binding);
        return binding;
    }

    @Override
    public ModuleFactory getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void add(Module module) {
        ModuleImpl moduleImpl = (ModuleImpl)module;
        HashMap<Type, BindingList> dir = new HashMap<Type, BindingList>();
        Map<Type, BindingList> map = moduleImpl.directory;
        synchronized (map) {
            dir.putAll(moduleImpl.directory);
        }
        for (Map.Entry entry : dir.entrySet()) {
            BindingList existing = this.directory.get(entry.getKey());
            if (existing != null) {
                existing.merge((BindingList)entry.getValue());
                continue;
            }
            this.directory.put((Type)entry.getKey(), (BindingList)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindClass(Class cls, Class implementation) {
        Type[] types = this.getBindClass(cls);
        Map<Type, BindingList> map = this.directory;
        synchronized (map) {
            for (Type type : types) {
                BindingList bindList = this.directory.computeIfAbsent(type, t -> new BindingList());
                bindList.bindClass(implementation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class getBoundClass(Class cls) {
        BindingList bindList = null;
        Map<Type, BindingList> map = this.directory;
        synchronized (map) {
            bindList = this.directory.get(cls);
        }
        if (bindList == null || bindList.unnamedBinding == null) {
            return null;
        }
        return bindList.unnamedBinding.getImplementation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object bindInstance(Class cls, Object inst) {
        Object instance = this.newInstance(inst);
        Type[] types = this.getBindClass(cls);
        Map<Type, BindingList> map = this.directory;
        synchronized (map) {
            for (Type type : types) {
                BindingList bindList = this.directory.computeIfAbsent(type, t -> new BindingList());
                bindList.bindInstance(null, instance);
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object bindNamedInstance(Class cls, String name, Object inst) {
        Object instance = this.newInstance(inst);
        Type[] types = this.getBindClass(cls);
        Map<Type, BindingList> map = this.directory;
        synchronized (map) {
            for (Type type : types) {
                BindingList bindList = this.directory.computeIfAbsent(type, t -> new BindingList());
                bindList.bindInstance(name, instance);
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object unbindInstance(Class cls) {
        Type[] types = this.getBindClass(cls);
        Map<Type, BindingList> map = this.directory;
        synchronized (map) {
            for (Type type : types) {
                BindingList bindList = this.directory.get(type);
                if (bindList == null) continue;
                Object value = bindList.unbind();
                if (bindList.namedBindings.size() == 0) {
                    this.directory.remove(type);
                }
                return value;
            }
        }
        return null;
    }

    private Object newInstance(Object instance) {
        if (instance instanceof Class) {
            try {
                return ((Class)instance).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new SystemException(e);
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getBoundNamedInstance(Class<T> cls, String name) {
        BindingList bindList = null;
        Map<Type, BindingList> map = this.directory;
        synchronized (map) {
            bindList = this.directory.get(cls);
        }
        if (bindList == null) {
            return null;
        }
        Binding binding = bindList.getBinding(name);
        if (binding == null) {
            return null;
        }
        return (T)binding.getValue();
    }

    @Override
    public <T> T getBoundInstance(Class<T> cls) {
        return this.getBoundNamedInstance(cls, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasInstance(Class cls) {
        Map<Type, BindingList> map = this.directory;
        synchronized (map) {
            return this.directory.containsKey(cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasBinding(Class cls) {
        Map<Type, BindingList> map = this.directory;
        synchronized (map) {
            return this.directory.containsKey(cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Injector build(Module ... components) {
        Injector parent = null;
        if (components != null && components.length > 0) {
            Module[] remaining = new Module[components.length - 1];
            if (remaining.length > 0) {
                System.arraycopy(components, 1, remaining, 0, components.length - 1);
            }
            parent = components[0].build(remaining);
        }
        InjectorImpl injector = new InjectorImpl(this, (InjectorImpl)parent);
        HashMap<Type, BindingList> dir = new HashMap<Type, BindingList>();
        Map<Type, BindingList> map = this.directory;
        synchronized (map) {
            dir.putAll(this.directory);
        }
        for (Map.Entry entry : dir.entrySet()) {
            ((BindingList)entry.getValue()).list().forEach(binding -> {
                if (binding.isSingleton()) {
                    injector.inject(binding.getValue());
                }
            });
        }
        return injector;
    }

    private static class BindingList {
        private Map<String, Binding> namedBindings = new HashMap<String, Binding>();
        private Binding unnamedBinding;

        private BindingList() {
        }

        Binding getBinding(String name) {
            if (name == null) {
                return this.unnamedBinding;
            }
            return this.namedBindings.get(name);
        }

        List<Binding> list() {
            ArrayList<Binding> list = new ArrayList<Binding>();
            if (this.unnamedBinding != null) {
                list.add(this.unnamedBinding);
            }
            list.addAll(this.namedBindings.values());
            return list;
        }

        void bindClass(Class implementation) {
            Binding binding;
            this.unnamedBinding = binding = new Binding(implementation);
        }

        void bindInstance(String name, Object instance) {
            Binding binding = new Binding(instance);
            if (name == null) {
                this.unnamedBinding = binding;
            } else {
                this.namedBindings.put(name, binding);
            }
        }

        Object unbind() {
            Object value = this.unnamedBinding.getValue();
            this.unnamedBinding = null;
            return value;
        }

        int namedBindingSize() {
            return this.namedBindings.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void merge(BindingList bindingList) {
            if (this.unnamedBinding == null) {
                this.unnamedBinding = bindingList.unnamedBinding;
            }
            HashMap<String, Binding> copy = new HashMap<String, Binding>();
            Map<String, Binding> map = bindingList.namedBindings;
            synchronized (map) {
                copy.putAll(bindingList.namedBindings);
            }
            for (String name : copy.keySet()) {
                if (this.namedBindings.containsKey(name)) continue;
                this.namedBindings.put(name, bindingList.namedBindings.get(name));
            }
        }
    }
}

