/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.logging;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import net.e6tech.elements.common.logging.LogLevel;
import net.e6tech.elements.common.logging.Logger;

public class TimedLogger {
    private static Set<String> includes = Collections.synchronizedSet(new HashSet());
    private static Set<String> excludes = Collections.synchronizedSet(new HashSet());
    private static String regex;
    private static Stack<StringBuilder> builders;
    private static long defaultTimeout;
    private long start = System.currentTimeMillis();
    private LogLevel logLevel = LogLevel.DEBUG;
    private Logger logger;
    private boolean shouldLog;
    private long timeout = defaultTimeout;

    public TimedLogger(String name) {
        this.logger = Logger.getLogger(name);
    }

    public TimedLogger(String name, long timeout) {
        this(name);
        this.timeout = timeout;
    }

    public TimedLogger(long timeout) {
        this();
        this.timeout = timeout;
    }

    public TimedLogger() {
        int i;
        this.logger = Logger.getLogger("TimedLogger");
        Throwable th = new Throwable();
        StackTraceElement[] trace = th.getStackTrace();
        String thisClassName = this.getClass().getName();
        for (i = 1; i < trace.length && thisClassName.equals(trace[i].getClassName()); ++i) {
        }
        this.shouldLog = false;
        if (trace.length > i) {
            String className = trace[i].getClassName();
            if (regex != null && className.matches(regex)) {
                this.shouldLog = true;
                if (excludes.contains(className)) {
                    this.shouldLog = false;
                }
            } else {
                if (excludes.contains(className)) {
                    this.shouldLog = false;
                    return;
                }
                if (includes.contains(className)) {
                    this.shouldLog = true;
                    return;
                }
            }
        }
        if (this.shouldLog) {
            this.computeLogging();
        }
    }

    public static void setRegex(String pattern) {
        regex = pattern;
    }

    public static void setExcludes(Class ... classes) {
        if (classes != null) {
            for (Class cls : classes) {
                excludes.add(cls.getName());
            }
        }
    }

    public static void setIncludes(Class ... classes) {
        if (classes != null) {
            for (Class cls : classes) {
                includes.add(cls.getName());
            }
        }
    }

    public static long getDefaultTimeout() {
        return defaultTimeout;
    }

    public static void setDefaultTimeout(long defaultTimeout) {
        TimedLogger.defaultTimeout = defaultTimeout;
    }

    private void computeLogging() {
        switch (this.logLevel) {
            case FATAL: 
            case ERROR: {
                if (this.logger.isErrorEnabled()) break;
                this.shouldLog = false;
                break;
            }
            case WARN: {
                if (this.logger.isWarnEnabled()) break;
                this.shouldLog = false;
                break;
            }
            case INFO: {
                if (this.logger.isInfoEnabled()) break;
                this.shouldLog = false;
                break;
            }
            case DEBUG: {
                if (this.logger.isDebugEnabled()) break;
                this.shouldLog = false;
                break;
            }
            case TRACE: {
                this.shouldLog = true;
                break;
            }
            default: {
                this.shouldLog = true;
            }
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        this.computeLogging();
    }

    public TimedLogger log() {
        return this._log("", this.timeout);
    }

    public TimedLogger log(String message) {
        return this._log(message, this.timeout);
    }

    public TimedLogger time() {
        return this._log("", 0L);
    }

    public TimedLogger time(String message) {
        return this._log(message, 0L);
    }

    private TimedLogger _log(String message, long timeout) {
        long duration = System.currentTimeMillis() - this.start;
        this.start = System.currentTimeMillis();
        if (duration <= timeout) {
            return this;
        }
        if (!this.shouldLog) {
            return this;
        }
        StringBuilder builder = TimedLogger.checkout();
        Thread thread = Thread.currentThread();
        builder.append("Thread[").append(thread.getName()).append("] ");
        this.getCallerInfo(builder);
        builder.append(": ").append(message).append(" ").append(duration).append("ms");
        switch (this.logLevel) {
            case FATAL: 
            case ERROR: {
                this.logger.error(builder.toString());
                break;
            }
            case WARN: {
                this.logger.warn(builder.toString());
                break;
            }
            case INFO: {
                this.logger.info(builder.toString());
                break;
            }
            case DEBUG: {
                this.logger.debug(builder.toString());
                break;
            }
            case TRACE: {
                this.logger.trace(builder.toString());
                break;
            }
        }
        builder.setLength(0);
        TimedLogger.checkin(builder);
        return this;
    }

    public long duration() {
        return System.currentTimeMillis() - this.start;
    }

    public TimedLogger start() {
        this.start = System.currentTimeMillis();
        return this;
    }

    protected void getCallerInfo(StringBuilder builder) {
        Throwable th = new Throwable();
        StackTraceElement[] trace = th.getStackTrace();
        String thisClassName = this.getClass().getName();
        int i = 0;
        if (i >= trace.length || thisClassName.equals(trace[i].getClassName())) {
            // empty if block
        }
        if (trace.length > i + 3) {
            builder.append(trace[i + 3].getClassName());
            builder.append(".");
            builder.append(trace[i + 3].getMethodName());
            builder.append("(");
            builder.append(trace[i + 3].getFileName());
            builder.append(":");
            builder.append(trace[i + 3].getLineNumber());
            builder.append(")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuilder checkout() {
        Stack<StringBuilder> stack = builders;
        synchronized (stack) {
            if (!builders.isEmpty()) {
                return builders.pop();
            }
        }
        return new StringBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkin(StringBuilder builder) {
        Stack<StringBuilder> stack = builders;
        synchronized (stack) {
            builders.push(builder);
        }
    }

    static {
        builders = new Stack();
        defaultTimeout = 50L;
    }
}

