/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.script;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.script.ScriptPath;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.file.FileUtil;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;

public class Scripting {
    public static final String SCRIPT_BASE_CLASS = "scriptBaseClass";
    public static final String PATH = "script.path";
    public static final String __DIR = "__dir";
    public static final String __FILE = "__file";
    public static final String __LOAD_DIR = "__load_dir";
    public static final String __LOAD_FILE = "__load_file";
    private static Logger logger = Logger.getLogger();
    private static final Set<String> reservedKeyWords = new HashSet<String>();
    GroovyEngine engine;
    List runAfterList = new LinkedList();
    List launchedList = new LinkedList();
    ScriptPath scriptPath;

    protected Scripting() {
    }

    public static Scripting newInstance(ClassLoader classLoader, Properties properties) {
        Scripting script = new Scripting();
        script.engine = new GroovyEngine(classLoader, properties, true);
        return script;
    }

    public void put(String key, Object val) {
        if (reservedKeyWords.contains(key)) {
            throw new SystemException(key + " is a reserved keyword");
        }
        this.privatePut(key, val);
    }

    public void privatePut(String key, Object val) {
        this.engine.put(key, val);
    }

    public Object get(String key) {
        return this.engine.get(key);
    }

    public <T> T get(String key, T defaultValue) {
        Object t = this.engine.get(key);
        return (T)(t == null ? defaultValue : t);
    }

    public Map<String, Object> getVariables() {
        return this.engine.getVariables();
    }

    public Object remove(String key) {
        return this.engine.remove(key);
    }

    public Properties getProperties() {
        return this.engine.getProperties();
    }

    private String normalizePath(String originalPath) {
        String dir = (String)this.get(__DIR);
        boolean relativePath = false;
        String path = originalPath;
        if (!(dir == null || path.startsWith(dir) || path.startsWith(File.separator) || path.startsWith("/") || path.startsWith("classpath:"))) {
            String prefix;
            int indexOfColon = path.indexOf(58);
            relativePath = indexOfColon > 0 ? !(prefix = path.substring(0, indexOfColon)).contains(File.separator) && !prefix.contains("/") : true;
        }
        if (relativePath) {
            path = dir + "/" + path;
        }
        return path;
    }

    public Object eval(Path script) throws ScriptException {
        return this.eval(script, false);
    }

    private Object eval(Path script, boolean topLevel) throws ScriptException {
        String prevRootDir = null;
        String prevRootFile = null;
        if (topLevel) {
            prevRootDir = (String)this.get(__LOAD_DIR);
            prevRootFile = (String)this.get(__LOAD_FILE);
        }
        ScriptPath prev = this.scriptPath;
        this.scriptPath = new ScriptPath(this.normalizePath(script.toString()));
        Reader reader = null;
        try {
            Object object;
            if (!Files.exists(this.scriptPath.getPath(), new LinkOption[0])) {
                String fileName = this.scriptPath.getFileName();
                boolean loadFromClassPath = false;
                if (fileName.startsWith("classpath://")) {
                    fileName = fileName.substring("classpath://".length());
                    loadFromClassPath = true;
                } else if (fileName.startsWith("classpath:/")) {
                    fileName = fileName.substring("classpath:/".length());
                    loadFromClassPath = true;
                } else if (fileName.startsWith("classpath:")) {
                    fileName = fileName.substring("classpath:".length());
                    loadFromClassPath = true;
                }
                this.scriptPath.setFileName(fileName);
                this.scriptPath.setClassPath(true);
                if (loadFromClassPath) {
                    InputStream stream = this.getClass().getClassLoader().getResourceAsStream(fileName);
                    if (stream == null) {
                        throw new IOException("File not found: " + fileName);
                    }
                    reader = new InputStreamReader(stream, "UTF-8");
                } else {
                    throw new IOException("Script not found: " + script);
                }
            }
            String dir = this.scriptPath.getParent();
            String file = this.scriptPath.getFileName();
            if (!this.scriptPath.isClassPath()) {
                dir = new File(dir).getCanonicalPath();
                file = new File(dir).getCanonicalPath();
            }
            this.privatePut(__DIR, dir);
            this.privatePut(__FILE, file);
            if (topLevel) {
                this.privatePut(__LOAD_DIR, dir);
                this.privatePut(__LOAD_FILE, file);
            }
            if (Files.exists(this.scriptPath.getPath(), new LinkOption[0])) {
                object = this.engine.eval(this.scriptPath.getPath().toFile());
                return object;
            }
            object = this.engine.eval(reader, this.scriptPath.getFileName());
            return object;
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        catch (ScriptException e) {
            logger.error("Error eval " + script.toString());
            throw e;
        }
        catch (Exception e) {
            logger.error("Error eval " + script.toString(), e);
            throw new ScriptException(e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            this.scriptPath = prev;
            if (prev != null) {
                this.privatePut(__DIR, prev.getParent());
                this.privatePut(__FILE, prev.getFileName());
            } else {
                this.privatePut(__DIR, null);
                this.privatePut(__FILE, null);
            }
            if (topLevel) {
                this.privatePut(__LOAD_DIR, prevRootDir);
                this.privatePut(__LOAD_FILE, prevRootFile);
            }
        }
    }

    public Object eval(String script) throws ScriptException {
        return this.engine.eval(script);
    }

    public boolean isRunnable(Object obj) {
        return obj instanceof Runnable || obj instanceof Closure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runNow(Object caller, Object callable) {
        Object ret = null;
        if (callable instanceof Closure) {
            Closure closure = (Closure)callable;
            try {
                Closure clonedClosure = (Closure)closure.clone();
                try {
                    clonedClosure.setResolveStrategy(1);
                    clonedClosure.setDelegate(caller);
                    ret = clonedClosure.call(caller);
                }
                finally {
                    clonedClosure.setDelegate(null);
                }
            }
            catch (Exception th) {
                logger.warn(th.getMessage(), th);
            }
        } else if (callable instanceof Runnable) {
            ((Runnable)callable).run();
        } else if (callable instanceof Callable) {
            try {
                ret = ((Callable)callable).call();
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
        } else {
            throw new SystemException("runNow " + callable + " cannot be run");
        }
        return ret;
    }

    public void runAfter(Runnable callable) {
        this.runAfterList.add(callable);
    }

    public void runAfter(Object callable) {
        this.runAfterList.add(callable);
    }

    public void runLaunched(Object callable) {
        this.launchedList.add(callable);
    }

    public void onLaunched() {
        this.executeList(this.launchedList);
        this.launchedList.clear();
    }

    protected String getExtension() {
        return ".groovy";
    }

    public void load(String path) throws ScriptException {
        this.exec(path, true);
        this.runAfter();
    }

    protected void runAfter() {
        this.executeList(this.runAfterList);
        this.runAfterList.clear();
    }

    private void executeList(List list) {
        Object[] items;
        for (Object obj : items = list.toArray(new Object[list.size()])) {
            if (obj instanceof Closure) {
                ((Closure)obj).call();
                continue;
            }
            if (obj instanceof Runnable) {
                ((Runnable)obj).run();
                continue;
            }
            String clsName = obj == null ? "null" : obj.getClass().getName();
            throw new SystemException("Expecting Closure or Runnable but got " + clsName);
        }
        for (Object obj : items) {
            if (!(obj instanceof Closure)) continue;
            Closure closure = (Closure)obj;
            closure.setDelegate(null);
            Object owner = closure.getOwner();
            if (owner == null || !(owner instanceof Closure)) continue;
            ((Closure)owner).setDelegate(null);
        }
    }

    public Object exec(String path) throws ScriptException {
        return this.exec(path, false);
    }

    private Object exec(String originalPath, boolean topLevel) throws ScriptException {
        Path[] paths;
        try {
            String path = this.normalizePath(originalPath);
            paths = this.listFiles(path);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        Object ret = null;
        for (Path p : paths) {
            Object val = this.eval(p, topLevel);
            if (val == null) continue;
            ret = val;
        }
        return ret;
    }

    private Path[] listFiles(String path) throws IOException {
        return FileUtil.listFiles(path, this.getExtension());
    }

    static {
        reservedKeyWords.add(__DIR);
        reservedKeyWords.add(__FILE);
    }

    private static class GroovyEngine {
        GroovyShell shell;
        GroovyScriptEngineImpl scriptEngine;
        ScriptContext scriptContext;

        public GroovyEngine(ClassLoader classLoader, Properties properties, boolean useGroovyShell) {
            ClassLoader ctxLoader = classLoader;
            if (ctxLoader == null) {
                ctxLoader = Thread.currentThread().getContextClassLoader();
            }
            if (ctxLoader == null) {
                ctxLoader = Scripting.class.getClassLoader();
            }
            CompilerConfiguration compilerConfig = new CompilerConfiguration();
            String scriptBaseClass = properties.getProperty(Scripting.SCRIPT_BASE_CLASS);
            if (scriptBaseClass != null) {
                compilerConfig.setScriptBaseClass(scriptBaseClass);
            }
            GroovyClassLoader loader = new GroovyClassLoader(ctxLoader, compilerConfig);
            if (properties.getProperty(Scripting.PATH) != null) {
                loader.addClasspath(properties.getProperty(Scripting.PATH));
            }
            if (useGroovyShell) {
                Binding binding = new Binding();
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    binding.setVariable(entry.getKey().toString(), entry.getValue());
                }
                this.shell = new GroovyShell((ClassLoader)loader, binding, compilerConfig);
            } else {
                this.scriptEngine = new GroovyScriptEngineImpl(loader);
                this.scriptContext = new SimpleScriptContext();
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    this.scriptContext.getBindings(100).put(entry.getKey().toString(), entry.getValue());
                }
            }
        }

        public void put(String key, Object val) {
            if (this.shell != null) {
                this.shell.setVariable(key, val);
            } else {
                this.scriptContext.getBindings(100).put(key, val);
            }
        }

        public Map<String, Object> getVariables() {
            Map binding = this.shell != null ? this.shell.getContext().getVariables() : this.scriptContext.getBindings(100);
            LinkedHashMap<String, Object> variables = new LinkedHashMap<String, Object>();
            for (Map.Entry entry : binding.entrySet()) {
                if (entry.getValue() instanceof GString) {
                    variables.put((String)entry.getKey(), entry.getValue().toString());
                    continue;
                }
                variables.put((String)entry.getKey(), entry.getValue());
            }
            return variables;
        }

        public Object get(String key) {
            if (this.shell != null) {
                if ("binding".equals(key)) {
                    return this.shell.getContext();
                }
                return this.shell.getVariable(key);
            }
            if ("binding".equals(key)) {
                return this.scriptContext.getBindings(100);
            }
            return this.scriptContext.getBindings(100).get(key);
        }

        public Object remove(String key) {
            if (this.shell != null) {
                return this.shell.getContext().getVariables().remove(key);
            }
            return this.scriptEngine.getBindings(100).remove(key);
        }

        public Properties getProperties() {
            if (this.shell != null) {
                Map binding = this.shell.getContext().getVariables();
                Properties properties = new Properties();
                for (Map.Entry key : binding.entrySet()) {
                    Object value = binding.get(key);
                    if (value == null) continue;
                    properties.setProperty(key.toString(), value.toString());
                }
                return properties;
            }
            Bindings bindings = this.scriptContext.getBindings(100);
            Properties properties = new Properties();
            for (Map.Entry entry : bindings.entrySet()) {
                if (entry.getValue() == null) continue;
                properties.setProperty((String)entry.getKey(), entry.getValue().toString());
            }
            return properties;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object eval(File file) throws ScriptException {
            try {
                if (this.shell != null) {
                    return this.shell.evaluate(file);
                }
                try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                    Object object = this.scriptEngine.eval((Reader)reader, this.scriptContext);
                    return object;
                }
            }
            catch (IOException ex) {
                throw new ScriptException(ex);
            }
        }

        public Object eval(Reader reader, String fileName) throws ScriptException {
            if (this.shell != null) {
                return this.shell.evaluate(reader, GroovyEngine.scriptName(fileName));
            }
            return this.scriptEngine.eval(reader, this.scriptContext);
        }

        public Object eval(String script) throws ScriptException {
            if (this.shell != null) {
                return this.shell.evaluate(script);
            }
            try {
                return this.scriptEngine.eval(script, this.scriptContext);
            }
            catch (ScriptException e) {
                logger.error("Error eval " + script);
                throw e;
            }
        }

        private static String scriptName(String fileName) {
            Path path = Paths.get(fileName, new String[0]);
            Path file = path.getFileName();
            if (file.toString().endsWith(".groovy")) {
                int idx = file.toString().lastIndexOf(46);
                String name = file.toString().substring(0, idx);
                name = name + "$script.groovy";
                file = Paths.get(name, new String[0]);
            } else {
                file = Paths.get(file.toString() + "$script", new String[0]);
            }
            Path parent = path.getParent();
            path = Paths.get(parent.toString(), file.toString());
            return path.toString();
        }
    }
}

