/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import net.e6tech.elements.common.resources.Configurable;
import net.e6tech.elements.common.resources.Configurator;
import net.e6tech.elements.common.resources.OnOpen;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.resources.ResourceProvider;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.Transactional;

public class UnitOfWork
implements Transactional,
Configurable<UnitOfWork> {
    private static final String RESOURCES_NOT_OPEN = "Resources not open.";
    ResourceManager resourceManager;
    List<ResourceProvider> resourceProviders = new LinkedList<ResourceProvider>();
    Consumer<Resources> preOpen;
    private Configurator configurator = new Configurator();
    Resources resources;

    public UnitOfWork(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public UnitOfWork preOpen(Consumer<Resources> consumer) {
        this.preOpen = consumer;
        return this;
    }

    public UnitOfWork onOpen(OnOpen onOpen) {
        this.resourceProviders.add(onOpen);
        return this;
    }

    public Resources getResources() {
        return this.resources;
    }

    @Override
    public Configurator configurator() {
        return this.configurator;
    }

    @Override
    public UnitOfWork configurable() {
        return this;
    }

    @Override
    public <T extends Resources> T open() {
        if (this.resources != null && this.resources.isOpen()) {
            return (T)this.resources;
        }
        this.resources = this.resourceManager.open(this.configurator, r -> {
            if (this.preOpen != null) {
                this.preOpen.accept((Resources)r);
            }
            for (ResourceProvider p : this.resourceProviders) {
                r.addResourceProvider(p);
            }
        });
        return (T)this.resources;
    }

    public void commit() {
        if (this.resources == null || !this.resources.isOpen()) {
            throw new IllegalStateException("Resources not opened");
        }
        this.resources.commit();
        this.cleanup();
    }

    public void abort() {
        if (this.resources == null || !this.resources.isOpen()) {
            return;
        }
        this.resources.abort();
        this.cleanup();
    }

    protected void cleanup() {
        this.resourceProviders.clear();
        this.resources = null;
        this.configurator.clear();
        this.preOpen = null;
    }

    public void submit(Transactional.RunnableWithException work) {
        if (this.resources == null || !this.resources.isOpen()) {
            throw new IllegalStateException(RESOURCES_NOT_OPEN);
        }
        this.resources.submit((R res) -> work.run());
    }

    public <T extends Resources> void submit(Transactional.ConsumerWithException<T> work) {
        if (this.resources == null || !this.resources.isOpen()) {
            throw new IllegalStateException(RESOURCES_NOT_OPEN);
        }
        this.resources.submit(work);
    }

    public <T> T submit(Callable<T> work) {
        if (this.resources == null || !this.resources.isOpen()) {
            throw new IllegalStateException(RESOURCES_NOT_OPEN);
        }
        return (T)this.resources.submit((T res) -> work.call());
    }

    public <T extends Resources, R> R submit(Transactional.FunctionWithException<T, R> work) {
        if (this.resources == null || !this.resources.isOpen()) {
            throw new IllegalStateException(RESOURCES_NOT_OPEN);
        }
        return this.resources.submit(work);
    }

    public boolean isOpened() {
        if (this.resources == null) {
            return false;
        }
        return this.resources.isOpen();
    }

    public boolean isAborted() {
        if (this.resources == null) {
            return false;
        }
        return this.resources.isAborted();
    }
}

