/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import java.lang.reflect.Proxy;
import net.e6tech.elements.common.resources.Resources;

public interface ResourceProvider {
    public static ResourceProvider wrap(String description, ResourceProvider resourceProvider) {
        return (ResourceProvider)Proxy.newProxyInstance(resourceProvider.getClass().getClassLoader(), new Class[]{ResourceProvider.class}, (proxy, method, args) -> {
            if ("getDescription".equals(method.getName()) && (args == null || args.length == 0)) {
                return description;
            }
            return method.invoke((Object)resourceProvider, args);
        });
    }

    default public void onOpen(Resources resources) {
    }

    default public void onCommit(Resources resources) {
    }

    default public void afterCommit(Resources resources) {
    }

    default public void onAbort(Resources resources) {
    }

    default public void onClosed(Resources resources) {
    }

    default public void onShutdown() {
    }

    default public String getDescription() {
        return this.getClass().getName();
    }
}

