/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources.plugin;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.e6tech.elements.common.inject.Injector;
import net.e6tech.elements.common.inject.Module;
import net.e6tech.elements.common.inject.ModuleFactory;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Binding;
import net.e6tech.elements.common.resources.InjectionListener;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.plugin.Plugin;
import net.e6tech.elements.common.resources.plugin.PluginPath;
import net.e6tech.elements.common.resources.plugin.PluginPaths;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.file.FileUtil;

public class PluginManager {
    private static final String DEFAULT_PLUGIN = "defaultPlugin";
    private static final Object NULL_OBJECT = new Object();
    private PluginClassLoader classLoader;
    private ResourceManager resourceManager;
    private Resources resources;
    private Map<String, Object> plugins = new HashMap<String, Object>();
    private Map<Class, Object> defaultPlugins = new HashMap<Class, Object>();

    public PluginManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.classLoader = new PluginClassLoader(resourceManager.getClass().getClassLoader());
    }

    public PluginManager from(Resources resources) {
        PluginManager plugin = new PluginManager(this.resourceManager);
        plugin.resources = resources;
        plugin.defaultPlugins = this.defaultPlugins;
        plugin.classLoader = this.classLoader;
        plugin.plugins = this.plugins;
        return plugin;
    }

    public void loadPlugins(String[] directories) {
        for (String dir : directories) {
            Path[] paths = new Path[]{};
            try {
                paths = FileUtil.listFiles(dir, "jar");
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
            for (Path p : paths) {
                try {
                    this.classLoader.addURL(p.toUri().toURL());
                }
                catch (MalformedURLException e) {
                    throw new SystemException(e);
                }
            }
        }
    }

    public ClassLoader getPluginClassLoader() {
        return this.classLoader;
    }

    protected Optional getDefaultPlugin(Class type) {
        Object lookup = this.defaultPlugins.get(type);
        if (lookup == NULL_OBJECT) {
            return Optional.empty();
        }
        if (lookup == null) {
            while (type != null && !type.equals(Object.class)) {
                try {
                    Field field = type.getField(DEFAULT_PLUGIN);
                    lookup = field.get(null);
                    this.defaultPlugins.put(type, lookup);
                    break;
                }
                catch (IllegalAccessException | NoSuchFieldException e1) {
                    Logger.suppress(e1);
                    type = type.getSuperclass();
                }
            }
            if (lookup == null) {
                this.defaultPlugins.put(type, NULL_OBJECT);
            }
        }
        return Optional.ofNullable(lookup);
    }

    public <T extends Plugin> Optional<T> get(PluginPaths<T> paths, Object ... args) {
        Plugin plugin;
        PluginPath path;
        String fullPath;
        Object lookup = null;
        Iterator<PluginPath> iterator = paths.getPaths().iterator();
        while (iterator.hasNext() && (lookup = this.plugins.get(fullPath = (path = iterator.next()).path())) == null) {
        }
        if (lookup == null) {
            Optional defaultPlugin = this.getDefaultPlugin(paths.getType());
            if (!defaultPlugin.isPresent()) {
                return Optional.empty();
            }
            lookup = defaultPlugin.get();
        }
        if (lookup instanceof Class) {
            try {
                plugin = (Plugin)((Class)lookup).newInstance();
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
        } else {
            plugin = (Plugin)lookup;
        }
        if (args != null && args.length > 0) {
            Injector injector;
            ModuleFactory factory = this.resources != null ? this.resources.getModule().getFactory() : this.resourceManager.getModule().getFactory();
            Module module = factory.create();
            for (Object arg : args) {
                if (arg instanceof Binding) {
                    Binding binding = (Binding)arg;
                    if (binding.getName() != null) {
                        module.bindNamedInstance(binding.getBoundClass(), binding.getName(), binding.get());
                        continue;
                    }
                    module.bindInstance(binding.getBoundClass(), binding.get());
                    continue;
                }
                module.bindInstance(arg.getClass(), arg);
            }
            Injector injector2 = injector = this.resources != null ? module.build(this.resources.getModule(), this.resourceManager.getModule()) : module.build(this.resourceManager.getModule());
            if (plugin instanceof InjectionListener) {
                ((InjectionListener)((Object)plugin)).preInject(this.resources);
            }
            injector.inject(plugin);
            if (plugin instanceof InjectionListener) {
                ((InjectionListener)((Object)plugin)).injected(this.resources);
            }
        }
        plugin.initialize();
        return Optional.of(plugin);
    }

    public <T extends Plugin> Optional<T> get(PluginPath<T> path, Object ... args) {
        return this.get(PluginPaths.of(path), args);
    }

    public synchronized <T extends Plugin> void add(PluginPath<T> path, Class<T> cls) {
        this.plugins.put(path.path(), cls);
    }

    public synchronized <T extends Plugin> void add(PluginPath<T> path, T object) {
        this.plugins.put(path.path(), object);
    }

    public synchronized <T extends Plugin, U extends T> void addDefault(Class<T> cls, U object) {
        this.defaultPlugins.put(cls, object);
    }

    public synchronized <T extends Plugin, U extends T> void addDefault(Class<T> cls, Class<U> implClass) {
        this.defaultPlugins.put(cls, implClass);
    }

    public Object removeDefault(Class cls) {
        return this.defaultPlugins.remove(cls);
    }

    public static class PluginClassLoader
    extends URLClassLoader {
        public PluginClassLoader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }
    }
}

