/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.cache;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javax.cache.Cache;
import net.e6tech.elements.common.cache.CacheConfiguration;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.util.SystemException;

public abstract class CacheFacade<K, V> {
    @Inject(optional=true)
    protected CacheConfiguration pool;
    protected String name;
    protected Class keyClass;
    protected Class valueClass;
    Cache<K, V> cache;

    public CacheFacade() {
        this(Reflection.getCallingClass(), null);
    }

    public CacheFacade(String name) {
        this(Reflection.getCallingClass(), name);
    }

    public CacheFacade(Class cls, String name) {
        String clsName;
        int last;
        Type genericSuper = this.getClass().getGenericSuperclass();
        if (genericSuper instanceof ParameterizedType) {
            ParameterizedType parametrizedType = (ParameterizedType)genericSuper;
            Type type = parametrizedType.getActualTypeArguments()[0];
            if (type instanceof Class) {
                this.keyClass = (Class)type;
            } else if (type instanceof ParameterizedType) {
                this.keyClass = (Class)((ParameterizedType)type).getRawType();
            }
            type = parametrizedType.getActualTypeArguments()[1];
            if (type instanceof Class) {
                this.valueClass = (Class)type;
            } else if (type instanceof ParameterizedType) {
                this.valueClass = (Class)((ParameterizedType)type).getRawType();
            }
        }
        if ((last = (clsName = cls.getName()).lastIndexOf(36)) > 0) {
            clsName = clsName.substring(0, last);
        }
        this.name = name != null ? clsName + "." + name : clsName;
    }

    public CacheFacade<K, V> initPool(Consumer<CacheConfiguration> configurator) {
        if (this.pool == null) {
            this.pool = new CacheConfiguration();
            configurator.accept(this.pool);
        }
        return this;
    }

    public CacheFacade<K, V> initPool() {
        return this.initPool(p -> p.setExpiry(900000L));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CacheConfiguration getPool() {
        return this.pool;
    }

    public void setPool(CacheConfiguration pool) {
        this.pool = pool;
    }

    public V get(K key) {
        return (V)this.getCache().get(key);
    }

    public V get(K key, Callable<V> callable) {
        Cache<K, V> c = this.getCache();
        Object value = c.get(key);
        if (value == null) {
            try {
                value = callable.call();
                c.put(key, value);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
        }
        return (V)value;
    }

    public boolean remove(K key) {
        Cache<K, V> c = this.getCache();
        return c.remove(key);
    }

    public void put(K key, V value) {
        this.getCache().put(key, value);
    }

    protected synchronized Cache<K, V> getCache() {
        if (this.cache != null) {
            return this.cache;
        }
        if (this.pool == null) {
            this.initPool();
        }
        this.cache = this.pool.getCache(this.name, this.keyClass, this.valueClass);
        return this.cache;
    }
}

