/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.cache.ehcache;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import net.e6tech.elements.common.cache.CachePool;
import net.e6tech.elements.common.cache.CacheProvider;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expirations;
import org.ehcache.jsr107.Eh107Configuration;
import org.ehcache.jsr107.EhcacheCachingProvider;

public class EhcacheProvider
implements CacheProvider {
    private static ExecutorService executorService = Executors.newSingleThreadExecutor(r -> new Thread(r, "EhcacheProviderCleaner"));

    @Override
    public String getProviderClassName() {
        return EhcacheCachingProvider.class.getName();
    }

    @Override
    public <K, V> Cache<K, V> createCache(CachePool<K, V> cachePool) {
        ResourcePoolsBuilder builder = cachePool.getMaxEntries() > 0L ? ResourcePoolsBuilder.heap((long)cachePool.getMaxEntries()) : ResourcePoolsBuilder.newResourcePoolsBuilder();
        CacheConfiguration cacheConfiguration = CacheConfigurationBuilder.newCacheConfigurationBuilder((Class)cachePool.getKeyClass(), (Class)cachePool.getValueClass(), (Builder)builder).withExpiry(Expirations.timeToLiveExpiration((Duration)Duration.of((long)cachePool.getExpiry(), (TimeUnit)TimeUnit.MILLISECONDS))).build();
        Cache cache = cachePool.getCacheManager().createCache(cachePool.getName(), Eh107Configuration.fromEhcacheCacheConfiguration((CacheConfiguration)cacheConfiguration));
        return (Cache)Proxy.newProxyInstance(Cache.class.getClassLoader(), new Class[]{Cache.class}, new CacheInvocationHandler<K, V>(cache, cachePool));
    }

    private class CacheInvocationHandler<K, V>
    implements InvocationHandler {
        Cache<K, V> cache;
        long lastPut;
        long expiry;

        CacheInvocationHandler(Cache<K, V> cache, CachePool<K, V> cachePool) {
            this.cache = cache;
            this.expiry = cachePool.getExpiry();
            this.lastPut = System.currentTimeMillis();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().startsWith("put") && System.currentTimeMillis() - this.lastPut > this.expiry) {
                executorService.submit(() -> this.cache.iterator().forEachRemaining(entry -> {}));
                this.lastPut = System.currentTimeMillis();
            }
            return method.invoke(this.cache, args);
        }
    }
}

