/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.TouchedExpiryPolicy;
import net.e6tech.elements.common.cache.CacheProvider;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.SystemException;

public class CachePool<K, V> {
    public static final long DEFAULT_EXPIRY = 900000L;
    private static final String DEFAULT_PROVIDER = "net.e6tech.elements.common.cache.ehcache.EhcacheProvider";
    private static Map<String, CacheManager> managers = new HashMap<String, CacheManager>();
    private CacheProvider provider;
    private String name;
    private Class<K> keyClass;
    private Class<V> valueClass;
    private long expiry = 900000L;
    private long maxEntries = 1024L;
    private boolean storeByValue = false;

    public CachePool(String name, Class<K> keyClass, Class<V> valueClass) {
        this.name = name;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
    }

    public String getName() {
        return this.name;
    }

    public Class getKeyClass() {
        return this.keyClass;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public CacheProvider getProvider() {
        return this.provider;
    }

    public void setProvider(CacheProvider provider) {
        this.provider = provider;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public void setExpiry(long expiry) {
        if (expiry <= 0L) {
            throw new IllegalArgumentException();
        }
        this.expiry = expiry;
    }

    public long getMaxEntries() {
        return this.maxEntries;
    }

    public void setMaxEntries(long maxEntries) {
        this.maxEntries = maxEntries;
    }

    public boolean isStoreByValue() {
        return this.storeByValue;
    }

    public void setStoreByValue(boolean storeByValue) {
        this.storeByValue = storeByValue;
    }

    public synchronized CacheManager getCacheManager() {
        if (this.provider == null) {
            try {
                this.provider = (CacheProvider)this.getClass().getClassLoader().loadClass(DEFAULT_PROVIDER).newInstance();
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
        }
        return managers.computeIfAbsent(this.provider.getProviderClassName(), key -> Caching.getCachingProvider((String)key).getCacheManager());
    }

    public Cache<K, V> getCache() {
        CacheManager cacheManager = this.getCacheManager();
        Cache cache = cacheManager.getCache(this.name, this.keyClass, this.valueClass);
        if (cache != null) {
            return cache;
        }
        return this.provider.createCache(this);
    }

    private Cache<K, V> buildJsr107Cache() {
        CacheManager cacheManager = this.getCacheManager();
        MutableConfiguration configuration = new MutableConfiguration();
        configuration.setTypes(this.keyClass, this.valueClass);
        configuration.setExpiryPolicyFactory(TouchedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.MILLISECONDS, this.expiry)));
        configuration.setStoreByValue(this.storeByValue);
        try {
            return cacheManager.createCache(this.name, (Configuration)configuration);
        }
        catch (CacheException ex) {
            Logger.suppress(ex);
            return cacheManager.getCache(this.name, this.keyClass, this.valueClass);
        }
    }
}

