/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.stream.Stream;

public class FileUtil {
    private static final Path[] EMPTY_FILE_LIST = new Path[0];

    private FileUtil() {
    }

    public static Path[] listFiles(String path, String extension) throws IOException {
        Path[] paths = EMPTY_FILE_LIST;
        if (path.endsWith("**")) {
            String dir = path.substring(0, path.length() - 2);
            if (Files.isDirectory(Paths.get(dir, new String[0]), new LinkOption[0])) {
                paths = FileUtil.listFiles(Paths.get(dir, new String[0]), extension, true);
            } else if (!Files.exists(Paths.get(dir, new String[0]), new LinkOption[0])) {
                throw new IOException("Directory " + dir + " does not exist");
            }
        } else if (path.endsWith("*")) {
            String dir = path.substring(0, path.length() - 1);
            if (Files.isDirectory(Paths.get(dir, new String[0]), new LinkOption[0])) {
                paths = FileUtil.listFiles(Paths.get(dir, new String[0]), extension, false);
            } else if (!Files.exists(Paths.get(dir, new String[0]), new LinkOption[0])) {
                throw new IOException("Directory " + dir + " does not exist");
            }
        } else if (extension != null) {
            Path[] pathArray;
            if (path.endsWith(extension)) {
                Path[] pathArray2 = new Path[1];
                pathArray = pathArray2;
                pathArray2[0] = Paths.get(path, new String[0]);
            } else {
                Path[] pathArray3 = new Path[1];
                pathArray = pathArray3;
                pathArray3[0] = Paths.get(path + extension, new String[0]);
            }
            paths = pathArray;
        } else {
            paths = new Path[]{Paths.get(path, new String[0])};
        }
        return paths;
    }

    private static Path[] listFiles(Path path, String extension, boolean recursive) throws IOException {
        LinkedList<Path> directories = new LinkedList<Path>();
        LinkedList<Path> list = new LinkedList<Path>();
        if (Files.isDirectory(path, new LinkOption[0])) {
            directories.add(path);
        } else if (extension != null && path.toString().endsWith(extension)) {
            list.add(path);
        } else if (extension == null) {
            list.add(path);
        }
        while (!directories.isEmpty()) {
            Path parent = (Path)directories.remove(0);
            Stream<Path> stream = Files.list(parent);
            Throwable throwable = null;
            try {
                stream.forEach(f -> {
                    if (Files.isDirectory(f, new LinkOption[0])) {
                        if (recursive) {
                            directories.add((Path)f);
                        }
                    } else if (extension != null && f.toString().endsWith(extension)) {
                        list.add((Path)f);
                    } else if (extension == null) {
                        list.add((Path)f);
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
        return list.toArray(new Path[list.size()]);
    }
}

