/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources.plugin;

import java.util.LinkedList;
import java.util.List;

public class PluginPath<T> {
    private PluginPath parent;
    private Class<T> type;
    private String name;

    protected PluginPath(Class<T> cls, String name) {
        this.type = cls;
        this.name = name;
    }

    public static <T> PluginPath<T> of(Class<T> cls, String name) {
        return new PluginPath<T>(cls, name);
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public <R> PluginPath<R> and(Class<R> cls, String name) {
        PluginPath<R> child = new PluginPath<R>(cls, name);
        child.parent = this;
        return child;
    }

    public <R> PluginPath<R> and(Class<R> cls) {
        PluginPath<R> child = new PluginPath<R>(cls, null);
        child.parent = this;
        return child;
    }

    public List<PluginPath> list() {
        LinkedList<PluginPath> list = new LinkedList<PluginPath>();
        PluginPath path = this;
        while (path != null) {
            list.addFirst(path);
            path = path.parent;
        }
        return list;
    }

    public String path() {
        StringBuilder builder = new StringBuilder();
        List<PluginPath> list = this.list();
        boolean first = true;
        for (PluginPath p : list) {
            if (first) {
                first = false;
            } else {
                builder.append("/");
            }
            builder.append(p.getType().getName());
            if (p.getName() == null) continue;
            builder.append("/").append(p.getName());
        }
        return builder.toString();
    }
}

