/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources.plugin;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import net.e6tech.elements.common.inject.Injector;
import net.e6tech.elements.common.inject.Module;
import net.e6tech.elements.common.inject.ModuleFactory;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Binding;
import net.e6tech.elements.common.resources.InjectionListener;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.plugin.Plugin;
import net.e6tech.elements.common.resources.plugin.PluginPath;
import net.e6tech.elements.common.util.InitialContextFactory;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.file.FileUtil;

public class PluginManager {
    private static final String DEFAULT_PLUGIN = "defaultPlugin";
    private PluginClassLoader classLoader;
    private Context context;
    private ResourceManager resourceManager;
    private Resources resources;
    private Map<Class, Object> defaultPlugins = new HashMap<Class, Object>();

    public PluginManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.classLoader = new PluginClassLoader(resourceManager.getClass().getClassLoader());
        this.context = new InitialContextFactory().createContext(new Hashtable());
    }

    public PluginManager from(Resources resources) {
        PluginManager plugin = new PluginManager(this.resourceManager);
        plugin.resources = resources;
        plugin.context = this.context;
        plugin.defaultPlugins = this.defaultPlugins;
        plugin.classLoader = this.classLoader;
        return plugin;
    }

    public void loadPlugins(String[] directories) {
        for (String dir : directories) {
            Path[] paths = new Path[]{};
            try {
                paths = FileUtil.listFiles(dir, "jar");
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
            for (Path p : paths) {
                try {
                    this.classLoader.addURL(p.toUri().toURL());
                }
                catch (MalformedURLException e) {
                    throw new SystemException(e);
                }
            }
        }
    }

    public ClassLoader getPluginClassLoader() {
        return this.classLoader;
    }

    public <T extends Plugin> T get(PluginPath<T> path, Object ... args) {
        Plugin plugin;
        Object lookup;
        block15: {
            String fullPath = path.path();
            lookup = null;
            try {
                lookup = this.context.lookup(fullPath);
            }
            catch (NamingException e) {
                Class<T> type;
                Logger.suppress(e);
                lookup = this.defaultPlugins.get(type);
                if (lookup != null) break block15;
                for (type = path.getType(); type != null && !type.equals(Object.class); type = type.getSuperclass()) {
                    try {
                        Field field = type.getField(DEFAULT_PLUGIN);
                        lookup = field.get(null);
                        this.defaultPlugins.put(path.getType(), lookup);
                        break;
                    }
                    catch (IllegalAccessException | NoSuchFieldException e1) {
                        Logger.suppress(e1);
                        continue;
                    }
                }
                if (lookup != null) break block15;
                throw new SystemException("Invalid plugin path: " + fullPath);
            }
        }
        if (lookup instanceof Class) {
            try {
                plugin = (Plugin)((Class)lookup).newInstance();
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
        } else {
            plugin = (Plugin)lookup;
        }
        if (args != null && args.length > 0) {
            Injector injector;
            ModuleFactory factory = this.resources != null ? this.resources.getModule().getFactory() : this.resourceManager.getModule().getFactory();
            Module module = factory.create();
            for (Object arg : args) {
                if (arg instanceof Binding) {
                    Binding binding = (Binding)arg;
                    if (binding.getName() != null) {
                        module.bindNamedInstance(binding.getBoundClass(), binding.getName(), binding.get());
                        continue;
                    }
                    module.bindInstance(binding.getBoundClass(), binding.get());
                    continue;
                }
                module.bindInstance(arg.getClass(), arg);
            }
            Injector injector2 = injector = this.resources != null ? module.build(this.resources.getModule(), this.resourceManager.getModule()) : module.build(this.resourceManager.getModule());
            if (plugin instanceof InjectionListener) {
                ((InjectionListener)((Object)plugin)).preInject(this.resources);
            }
            injector.inject(plugin);
            if (plugin instanceof InjectionListener) {
                ((InjectionListener)((Object)plugin)).injected(this.resources);
            }
        }
        plugin.initialize();
        return (T)plugin;
    }

    public <T extends Plugin> void add(PluginPath<T> path, Class<T> cls) {
        try {
            this.context.rebind(path.path(), cls);
        }
        catch (NamingException e) {
            throw new SystemException(e);
        }
    }

    public <T extends Plugin> void add(PluginPath<T> path, T object) {
        try {
            this.context.rebind(path.path(), object);
        }
        catch (NamingException e) {
            throw new SystemException(e);
        }
    }

    public <T extends Plugin, U extends T> void addDefault(Class<T> cls, U object) {
        this.defaultPlugins.put(cls, object);
    }

    public <T extends Plugin, U extends T> void addDefault(Class<T> cls, Class<U> implClass) {
        this.defaultPlugins.put(cls, implClass);
    }

    public Object removeDefault(Class cls) {
        return this.defaultPlugins.remove(cls);
    }

    public static class PluginClassLoader
    extends URLClassLoader {
        public PluginClassLoader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }
    }
}

