/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.TouchedExpiryPolicy;
import net.e6tech.elements.common.logging.Logger;

public class CachePool {
    public static final long DEFAULT_EXPIRY = 900000L;
    private static Map<String, CacheManager> managers = new HashMap<String, CacheManager>();
    private String provider = "org.ehcache.jsr107.EhcacheCachingProvider";
    protected long expiry = 900000L;
    protected boolean storeByValue = false;

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public void setExpiry(long expiry) {
        if (expiry <= 0L) {
            throw new IllegalArgumentException();
        }
        this.expiry = expiry;
    }

    public boolean isStoreByValue() {
        return this.storeByValue;
    }

    public void setStoreByValue(boolean storeByValue) {
        this.storeByValue = storeByValue;
    }

    protected synchronized CacheManager getCacheManager() {
        return managers.computeIfAbsent(this.provider, key -> Caching.getCachingProvider((String)key).getCacheManager());
    }

    public <K, V> Cache<K, V> getCache(String name, Class<K> keyClass, Class<V> valueClass) {
        CacheManager cacheManager = this.getCacheManager();
        Cache cache = cacheManager.getCache(name, keyClass, valueClass);
        if (cache != null) {
            return cache;
        }
        MutableConfiguration configuration = new MutableConfiguration();
        configuration.setTypes(keyClass, valueClass);
        configuration.setExpiryPolicyFactory(TouchedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.MILLISECONDS, this.expiry)));
        configuration.setStoreByValue(this.storeByValue);
        try {
            return cacheManager.createCache(name, (Configuration)configuration);
        }
        catch (CacheException ex) {
            Logger.suppress(ex);
            return cacheManager.getCache(name, keyClass, valueClass);
        }
    }
}

