/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.inject.spi;

import com.google.inject.name.Named;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.inject.Injector;
import net.e6tech.elements.common.inject.spi.Binding;
import net.e6tech.elements.common.inject.spi.ModuleImpl;

public class InjectorImpl
implements Injector {
    private static Map<String, List<InjectionPoint>> injectionPoints = Collections.synchronizedMap(new WeakHashMap());
    private ModuleImpl module;
    private InjectorImpl parentInjector;
    private Map<Type, BoundInstances> instances = new HashMap<Type, BoundInstances>();

    public InjectorImpl(ModuleImpl module) {
        this.module = module;
    }

    public InjectorImpl(ModuleImpl module, InjectorImpl parentInjector) {
        this.module = module;
        this.parentInjector = parentInjector;
    }

    @Override
    public <T> T getInstance(Class<T> cls) {
        return this.getNamedInstance(cls, null);
    }

    @Override
    public <T> T getNamedInstance(Class<T> boundClass, String name) {
        return this._getNamedInstance(boundClass, name).map(entry -> entry.value).orElse(null);
    }

    private Optional<Entry> _getNamedInstance(Type boundClass, String name) {
        BoundInstances boundInstances = this.instances.get(boundClass);
        Entry entry = null;
        if (boundInstances == null && boundClass instanceof ParameterizedType) {
            boundInstances = this.instances.get(((ParameterizedType)boundClass).getRawType());
        }
        if (boundInstances != null) {
            entry = boundInstances.getInstance(name);
        }
        if (entry == null) {
            Type type = boundClass;
            Binding binding = this.module.getBinding(type, name);
            if (binding == null && type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
                binding = this.module.getBinding(type, name);
            }
            if (binding != null) {
                if (boundInstances == null) {
                    boundInstances = new BoundInstances();
                    this.instances.put(type, boundInstances);
                }
                Object instance = null;
                if (binding.isSingleton()) {
                    instance = binding.getValue();
                } else {
                    try {
                        instance = binding.getImplementation().newInstance();
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
                entry = boundInstances.put(name, instance);
                if (!binding.isSingleton()) {
                    this.inject(instance);
                }
            } else if (this.parentInjector != null) {
                entry = this.parentInjector._getNamedInstance(boundClass, name).orElse(null);
            }
        }
        return Optional.ofNullable(entry);
    }

    @Override
    public void inject(Object instance) {
        if (instance == null) {
            return;
        }
        Class<?> instanceClass = instance.getClass();
        List points = injectionPoints.computeIfAbsent(instance.getClass().getTypeName(), className -> this.parseInjectionPoints(instanceClass));
        points.forEach(pt -> {
            boolean injected = this.inject((InjectionPoint)pt, instance);
            if (!injected) {
                throw new RuntimeException("Cannot inject " + ((InjectionPoint)pt).field + "; no instances bound to " + ((InjectionPoint)pt).field.getType());
            }
        });
    }

    protected boolean inject(InjectionPoint point, Object instance) {
        boolean injected = false;
        boolean myAttempt = point.inject(this, instance);
        if (myAttempt) {
            return true;
        }
        if (this.parentInjector != null) {
            return this.parentInjector.inject(point, instance);
        }
        return false;
    }

    List<InjectionPoint> parseInjectionPoints(Class instanceClass) {
        ArrayList<InjectionPoint> list = new ArrayList<InjectionPoint>();
        for (Class cls = instanceClass; cls != Object.class; cls = cls.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                InjectionPoint injectionPoint = null;
                String name = null;
                boolean optional = false;
                Inject inject = field.getDeclaredAnnotation(Inject.class);
                if (inject != null) {
                    injectionPoint = new InjectionPoint();
                    optional = inject.optional();
                } else {
                    com.google.inject.Inject gInject = field.getDeclaredAnnotation(com.google.inject.Inject.class);
                    if (gInject != null) {
                        injectionPoint = new InjectionPoint();
                        optional = gInject.optional();
                    } else {
                        javax.inject.Inject jInject = field.getDeclaredAnnotation(javax.inject.Inject.class);
                        if (jInject != null) {
                            injectionPoint = new InjectionPoint();
                        }
                    }
                }
                if (injectionPoint != null) {
                    javax.inject.Named named = field.getDeclaredAnnotation(javax.inject.Named.class);
                    if (named != null) {
                        name = named.value();
                    } else {
                        Named gNamed = field.getDeclaredAnnotation(Named.class);
                        if (gNamed != null) {
                            name = gNamed.value();
                        }
                    }
                }
                if (injectionPoint == null) continue;
                injectionPoint.field = field;
                field.setAccessible(true);
                injectionPoint.optional = optional;
                injectionPoint.name = name;
                list.add(injectionPoint);
            }
        }
        return list;
    }

    private static class InjectionPoint {
        private Field field;
        private String name;
        private boolean optional;

        private InjectionPoint() {
        }

        public boolean inject(InjectorImpl injector, Object target) {
            Optional opt = injector._getNamedInstance(this.field.getGenericType(), this.name);
            if (!opt.isPresent() && !this.optional) {
                return false;
            }
            opt.ifPresent(entry -> {
                try {
                    this.field.set(target, entry.value());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
            return true;
        }
    }

    private static class Entry {
        Object value;

        Entry(Object value) {
            this.value = value;
        }

        Object value() {
            return this.value;
        }
    }

    private static class BoundInstances {
        Map<String, Entry> namedInstances = new HashMap<String, Entry>();
        Entry unnamedInstance;

        private BoundInstances() {
        }

        Entry getInstance(String name) {
            if (name == null) {
                return this.unnamedInstance;
            }
            return this.namedInstances.get(name);
        }

        Entry put(String name, Object instance) {
            Entry entry = new Entry(instance);
            if (name == null) {
                this.unnamedInstance = entry;
            } else {
                this.namedInstances.put(name, entry);
            }
            return entry;
        }
    }
}

