/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.inject.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.name.Names;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.e6tech.elements.common.inject.Injector;
import net.e6tech.elements.common.inject.Module;
import net.e6tech.elements.common.inject.ModuleFactory;
import net.e6tech.elements.common.inject.guice.GuiceInjector;
import net.e6tech.elements.common.logging.Logger;

public class GuiceModule
extends AbstractModule
implements Module {
    private static Logger logger = Logger.getLogger();
    private ModuleFactory factory;
    private Map<Type, Entry> bindInstances = new HashMap<Type, Entry>();
    private Map<Type, Map<String, Entry>> bindNamedInstances = new HashMap<Type, Map<String, Entry>>();
    private Map<Type, Class> bindClasses = new HashMap<Type, Class>();
    private Map<Type, InjectionListener> listeners = new LinkedHashMap<Type, InjectionListener>();

    public GuiceModule(ModuleFactory factory) {
        this.factory = factory;
    }

    @Override
    public ModuleFactory getFactory() {
        return this.factory;
    }

    @Override
    public synchronized Object bindInstance(Class cls, Object instance) {
        instance = this.newInstance(instance);
        Type[] types = this.getBindClass(cls);
        Entry entry = new Entry(instance);
        for (Type type : types) {
            this.bindInstances.put(type, entry);
        }
        return instance;
    }

    @Override
    public synchronized Object unbindInstance(Class cls) {
        Type[] types = this.getBindClass(cls);
        Entry entry = null;
        for (Type type : types) {
            entry = this.bindInstances.remove(type);
        }
        if (entry != null) {
            return entry.instance;
        }
        return null;
    }

    @Override
    public synchronized Object bindNamedInstance(Class cls, String name, Object instance) {
        instance = this.newInstance(instance);
        Type[] types = this.getBindClass(cls);
        Entry entry = new Entry(instance);
        for (Type type : types) {
            Map map = this.bindNamedInstances.computeIfAbsent(type, t -> new HashMap());
            map.put(name, entry);
        }
        return instance;
    }

    private Object newInstance(Object instance) {
        if (instance instanceof Class) {
            try {
                instance = ((Class)instance).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw logger.runtimeException(e);
            }
        }
        return instance;
    }

    @Override
    public synchronized <T> T getBoundNamedInstance(Class<T> cls, String name) {
        Map<String, Entry> map = this.bindNamedInstances.get(cls);
        if (map == null) {
            return null;
        }
        Entry entry = map.get(name);
        if (entry == null) {
            return null;
        }
        return (T)entry.instance;
    }

    @Override
    public synchronized <T> T getBoundInstance(Class<T> cls) {
        Entry entry = this.bindInstances.get(cls);
        if (entry == null) {
            return null;
        }
        return (T)entry.instance;
    }

    public synchronized boolean hasInstance(Class cls) {
        return this.bindInstances.containsKey(cls);
    }

    public synchronized Object getInstance(Class cls) {
        Entry entry = this.bindInstances.get(cls);
        if (entry == null) {
            return null;
        }
        return entry.instance;
    }

    @Override
    public synchronized void bindClass(Class cls, Class service) {
        Type[] types;
        for (Type type : types = this.getBindClass(cls)) {
            this.bindClasses.put(type, service);
        }
    }

    @Override
    public synchronized Class getBoundClass(Class cls) {
        return this.bindClasses.get(cls);
    }

    public synchronized boolean hasBinding(Class cls) {
        return this.bindInstances.containsKey(cls) || this.bindClasses.containsKey(cls);
    }

    void bindListener(Class cls, InjectionListener listener) {
        Type[] types;
        for (Type type : types = this.getBindClass(cls)) {
            this.listeners.put(type, listener);
        }
    }

    boolean hasListener(Class cls) {
        return this.listeners.containsKey(cls);
    }

    @Override
    public synchronized void add(Module module) {
        BiConsumer<Map, Map> copy = (from, to) -> {
            for (Object key : from.keySet()) {
                if (to.containsKey(key)) continue;
                to.put(key, from.get(key));
            }
        };
        GuiceModule guiceModule = (GuiceModule)module;
        copy.accept(guiceModule.bindClasses, this.bindClasses);
        copy.accept(guiceModule.bindNamedInstances, this.bindNamedInstances);
        copy.accept(guiceModule.bindInstances, this.bindInstances);
        copy.accept(guiceModule.listeners, this.listeners);
    }

    @Override
    public Injector build(Module ... additional) {
        ArrayList<GuiceModule> moduleList = new ArrayList<GuiceModule>();
        if (additional != null) {
            for (Module m : additional) {
                moduleList.add((GuiceModule)m);
            }
        }
        return this.createInjector(moduleList);
    }

    public Injector createInjector(Iterable<? extends GuiceModule> additional) {
        ArrayList<GuiceModule> moduleList = new ArrayList<GuiceModule>();
        moduleList.add(this);
        additional.forEach(m -> moduleList.add((GuiceModule)m));
        Collections.reverse(moduleList);
        HashMap<Type, Entry> bindInstances = new HashMap<Type, Entry>();
        HashMap<Type, Map<String, Entry>> bindNamedInstances = new HashMap<Type, Map<String, Entry>>();
        HashMap<Type, Class> bindClasses = new HashMap<Type, Class>();
        for (GuiceModule m2 : moduleList) {
            bindInstances.putAll(m2.bindInstances);
            for (Type type : m2.bindNamedInstances.keySet()) {
                Map map = bindNamedInstances.computeIfAbsent(type, t -> new HashMap());
                map.putAll(m2.bindNamedInstances.get(type));
            }
            bindClasses.putAll(m2.bindClasses);
        }
        GuiceModule resultingModule = new GuiceModule(this.factory);
        resultingModule.bindInstances = bindInstances;
        resultingModule.bindNamedInstances = bindNamedInstances;
        resultingModule.bindClasses = bindClasses;
        resultingModule.listeners = this.listeners;
        com.google.inject.Injector gInjector = Guice.createInjector((com.google.inject.Module[])new com.google.inject.Module[]{resultingModule});
        GuiceInjector injector = new GuiceInjector(gInjector);
        this.inject(injector);
        return injector;
    }

    private void inject(Injector injector) {
        for (Type type : this.bindNamedInstances.keySet()) {
            Map<String, Entry> map = this.bindNamedInstances.get(type);
            for (String name : map.keySet()) {
                Entry entry = map.get(name);
                if (entry.instance == null) continue;
                injector.inject(entry.instance);
            }
        }
        for (Type type : this.bindInstances.keySet()) {
            Entry entry = this.bindInstances.get(type);
            if (entry == null || entry.instance == null) continue;
            injector.inject(entry.instance);
        }
    }

    protected void configure() {
        this.binder().requireExplicitBindings();
        for (Type type : this.bindClasses.keySet()) {
            if (type instanceof Class) {
                this.bind((Class)type).to(this.bindClasses.get(type));
                continue;
            }
            this.bind(TypeLiteral.get((Type)type)).to(this.bindClasses.get(type));
        }
        for (Type type : this.bindNamedInstances.keySet()) {
            Map<String, Entry> map = this.bindNamedInstances.get(type);
            for (String name : map.keySet()) {
                Entry entry = map.get(name);
                if (type instanceof Class) {
                    this.bind((Class)type).annotatedWith((Annotation)Names.named((String)name)).toProvider(this.newInstanceProvider(entry.instance));
                    continue;
                }
                this.bind(TypeLiteral.get((Type)type)).annotatedWith((Annotation)Names.named((String)name)).toProvider(this.newInstanceProvider(entry.instance));
            }
        }
        for (Type type : this.bindInstances.keySet()) {
            Entry entry = this.bindInstances.get(type);
            try {
                if (type instanceof Class) {
                    if (entry != null) {
                        if (entry.instance != null) {
                            this.bind((Class)type).toProvider(this.newInstanceProvider(entry.instance));
                            continue;
                        }
                        this.bind((Class)type).toProvider(() -> null);
                        continue;
                    }
                    this.bind((Class)type).toProvider(() -> null);
                    continue;
                }
                if (entry != null) {
                    if (entry.instance != null) {
                        this.bind(TypeLiteral.get((Type)type)).toProvider(this.newInstanceProvider(entry.instance));
                        continue;
                    }
                    this.bind(TypeLiteral.get((Type)type)).toProvider(this.newInstanceProvider(null));
                    continue;
                }
                this.bind(TypeLiteral.get((Type)type)).toProvider(this.newInstanceProvider(null));
            }
            catch (Throwable th) {
                logger.error("Cannot bind " + type + " to " + entry);
                throw th;
            }
        }
        for (final Type key : this.listeners.keySet()) {
            final InjectionListener listener = this.listeners.get(key);
            TypeListener lis = new TypeListener(){

                public void hear(TypeLiteral type, TypeEncounter encounter) {
                    encounter.register(listener);
                }
            };
            this.bindListener((Matcher)new AbstractMatcher<TypeLiteral>(){

                public boolean matches(TypeLiteral typeLiteral) {
                    return typeLiteral.getType().equals(key);
                }
            }, lis);
        }
    }

    private Provider newInstanceProvider(Object instance) {
        InstanceProvider provider = new InstanceProvider();
        provider.instance = instance;
        return provider;
    }

    static class InstanceProvider
    implements Provider {
        Object instance;

        InstanceProvider() {
        }

        public Object get() {
            return this.instance;
        }
    }

    private class Entry {
        Object instance;

        Entry(Object i) {
            this.instance = i;
        }
    }
}

