/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.actor.pool;

import akka.actor.AbstractActor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.actor.Terminated;
import akka.japi.Creator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.e6tech.elements.common.actor.pool.Events;
import net.e6tech.elements.common.actor.pool.Worker;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class WorkerPool
extends AbstractActor {
    private int initialCapacity = 1;
    private int maxCapacity = Integer.MAX_VALUE;
    private long idleTimeout = 10000L;
    private boolean cleanupScheduled = false;
    private Set<ActorRef> workers = new LinkedHashSet<ActorRef>();
    private Set<ActorRef> idleWorkers = new LinkedHashSet<ActorRef>();
    private LinkedList<Task> waiting = new LinkedList();

    public static ActorRef newPool(ActorSystem system, int initialCapacity, int maxCapacity, long idleTimeout) {
        return system.actorOf(Props.create(WorkerPool.class, (Creator & Serializable)() -> {
            WorkerPool instance = new WorkerPool();
            instance.setInitialCapacity(initialCapacity);
            instance.setMaxCapacity(maxCapacity);
            instance.setIdleTimeout(idleTimeout);
            return instance;
        }));
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        if (idleTimeout < 0L) {
            throw new IllegalArgumentException();
        }
        this.idleTimeout = idleTimeout;
    }

    public void preStart() {
        for (int i = 0; i < this.initialCapacity; ++i) {
            this.newWorker();
        }
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(Events.IdleWorker.class, event -> this.idle(event.getWorker())).match(Terminated.class, event -> {
            this.workers.remove(event.actor());
            this.idleWorkers.remove(event.actor());
        }).match(Runnable.class, event -> this.newTask(event)).match(Callable.class, event -> this.newTask(event)).match(Events.Cleanup.class, events -> {
            if (this.idleWorkers.size() > this.initialCapacity) {
                Iterator<ActorRef> iterator = this.idleWorkers.iterator();
                int removeCount = this.idleWorkers.size() - this.initialCapacity;
                for (int i = 0; i < removeCount; ++i) {
                    ActorRef worker = iterator.next();
                    iterator.remove();
                    this.workers.remove(worker);
                    worker.tell((Object)PoisonPill.getInstance(), this.getSelf());
                }
            }
            this.cleanupScheduled = false;
        }).build();
    }

    private void newTask(Object event) {
        if (this.idleWorkers.size() > 0) {
            Iterator<ActorRef> iterator = this.idleWorkers.iterator();
            ActorRef worker = iterator.next();
            iterator.remove();
            worker.forward(event, (ActorContext)this.getContext());
        } else if (this.workers.size() < this.maxCapacity) {
            this.waiting.add(new Task(this.getSender(), event));
            this.newWorker();
        } else {
            this.waiting.add(new Task(this.getSender(), event));
        }
    }

    private void newWorker() {
        ActorRef worker = this.getContext().actorOf(Props.create(Worker.class, (Object[])new Object[]{this.getSelf()}).withDispatcher("worker-pool-dispatcher"));
        this.workers.add(worker);
        this.getContext().watch(worker);
        this.idle(worker);
    }

    private void idle(ActorRef worker) {
        if (this.waiting.size() > 0) {
            Task task = this.waiting.removeFirst();
            worker.tell(task.getWork(), task.getSender());
        } else {
            this.idleWorkers.add(worker);
            this.cleanup();
        }
    }

    private void cleanup() {
        if (this.cleanupScheduled) {
            return;
        }
        if (this.idleTimeout == 0L) {
            return;
        }
        FiniteDuration interval = Duration.create((long)this.idleTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
        this.getContext().getSystem().scheduler().scheduleOnce(interval, new Runnable(){

            @Override
            public void run() {
                WorkerPool.this.getSelf().tell((Object)new Events.Cleanup(), WorkerPool.this.getSelf());
            }
        }, (ExecutionContext)this.getContext().dispatcher());
    }

    private class Task {
        ActorRef sender;
        Object work;

        public Task(ActorRef sender, Object work) {
            this.sender = sender;
            this.work = work;
        }

        public ActorRef getSender() {
            return this.sender;
        }

        public Object getWork() {
            return this.work;
        }
    }
}

