/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util;

import java.lang.reflect.Constructor;

public interface Rethrowable {
    default public RuntimeException runtimeException(Throwable e) {
        return this.runtimeException(e.getMessage(), e);
    }

    default public RuntimeException runtimeException(String msg) {
        return this.runtimeException(msg, null);
    }

    default public RuntimeException runtimeException(String msg, Throwable th) {
        RuntimeException e = null;
        if (th == null) {
            e = new RuntimeException(msg);
        }
        if (th == null) {
            return e;
        }
        return new RuntimeException(th);
    }

    default public <T extends Throwable> T exception(Class<T> exceptionClass, Throwable e) {
        return this.exception(exceptionClass, e.getMessage(), e);
    }

    default public <T extends Throwable> T exception(Class<T> exceptionClass, String msg, Throwable e) {
        Constructor<T> constructor = null;
        Throwable th = null;
        try {
            constructor = exceptionClass.getConstructor(Throwable.class);
            th = (Throwable)constructor.newInstance(e);
        }
        catch (Throwable ex) {
            e.printStackTrace();
        }
        if (th == null) {
            try {
                constructor = exceptionClass.getConstructor(String.class);
                th = (Throwable)constructor.newInstance(msg);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (constructor == null) {
            try {
                constructor = exceptionClass.getConstructor(new Class[0]);
                th = (Throwable)constructor.newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return (T)th;
    }
}

