/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import net.e6tech.elements.common.resources.AlreadyBoundException;
import net.e6tech.elements.common.resources.InjectionListener;
import net.e6tech.elements.common.resources.InjectionModule;
import net.e6tech.elements.common.resources.InstanceNotFoundException;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.resources.ResourceProvider;
import net.e6tech.elements.common.resources.Resources;

class ResourcesState {
    private InjectionModule module;
    private Injector injector;
    private State state = State.Initial;
    private boolean dirty = false;
    private List<ResourceProvider> resourceProviders = new LinkedList<ResourceProvider>();
    private LinkedList<Object> injectionList = new LinkedList();

    ResourcesState() {
        this.module = new InjectionModule();
    }

    protected void cleanup() {
        this.module = new InjectionModule();
        this.resourceProviders.clear();
        this.state = State.Initial;
        this.dirty = false;
    }

    void discard() {
        this.module = null;
        this.resourceProviders = null;
    }

    public InjectionModule getModule() {
        return this.module;
    }

    public void setModule(InjectionModule module) {
        this.module = module;
    }

    public Injector getInjector() {
        return this.injector;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public List<ResourceProvider> getResourceProviders() {
        return this.resourceProviders;
    }

    public void setResourceProviders(List<ResourceProvider> resourceProviders) {
        this.resourceProviders = resourceProviders;
    }

    public LinkedList<Object> getInjectionList() {
        return this.injectionList;
    }

    public void setInjectionList(LinkedList<Object> injectionList) {
        this.injectionList = injectionList;
    }

    public void addModule(InjectionModule module) {
        this.module.add(module);
        this.setDirty(true);
    }

    protected void onOpen(Resources resources) {
        if (this.injectionList.size() > 0) {
            this.createInjector(resources);
        }
    }

    protected void createInjector(Resources resources) {
        this.injector = resources.getResourceManager() != null ? this.getModule().createInjector(resources.getResourceManager().getModule()) : this.getModule().createInjector(new InjectionModule[0]);
        this.setDirty(false);
        while (this.injectionList.size() > 0) {
            Object obj = this.injectionList.remove();
            this._inject(resources, this.injector, obj);
        }
    }

    public <T> T inject(Resources resources, T object) {
        if (object == null) {
            return object;
        }
        if (this.state == State.Initial) {
            this.injectionList.add(object);
        } else {
            if (this.isDirty() || this.injector == null) {
                this.createInjector(resources);
            }
            this._inject(resources, this.injector, object);
        }
        return object;
    }

    protected void _inject(Resources resources, Injector injector, Object object) {
        if (object instanceof InjectionListener) {
            ((InjectionListener)object).preInject(resources);
        }
        injector.injectMembers(object);
        if (object instanceof InjectionListener) {
            ((InjectionListener)object).injected(resources);
        }
    }

    public <T> T tryBind(Resources resources, Class<T> cls, Callable<T> callable) {
        T o = this.getModule().getBoundInstance(cls);
        if (o != null) {
            return o;
        }
        Object instance = null;
        try {
            instance = this.getModule().bindInstance(cls, callable.call());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setDirty(true);
        return (T)instance;
    }

    public <T> T bind(Resources resources, Class<T> cls, T resource) {
        T o = this.getModule().getBoundInstance(cls);
        if (o != null) {
            throw new AlreadyBoundException("Class " + cls + " is already bound to " + o);
        }
        Object instance = this.getModule().bindInstance(cls, resource);
        this.setDirty(true);
        return (T)instance;
    }

    public <T> T rebind(Resources resources, Class<T> cls, T resource) {
        Object instance = null;
        try {
            instance = this.getModule().bindInstance(cls, resource);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setDirty(true);
        return (T)instance;
    }

    public <T> T unbind(Class<T> cls) {
        Object instance = null;
        try {
            instance = this.getModule().unbindInstance(cls);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setDirty(true);
        return (T)instance;
    }

    public void bindClass(Class cls, Class service) {
        Class c = this.getModule().getBoundClass(cls);
        if (c != null) {
            throw new AlreadyBoundException("Class " + cls + " is already bound to " + c);
        }
        if (service != null) {
            this.getModule().bindClass(cls, service);
        } else {
            this.getModule().bindInstance(cls, null);
        }
        this.setDirty(true);
    }

    public <T> T bindNamedInstance(String name, Class<T> cls, T resource) {
        Object o = this.getModule().getBoundNamedInstance(name);
        if (o != null) {
            throw new AlreadyBoundException("Class " + cls + " is already bound to " + o);
        }
        return this.rebindNamedInstance(name, cls, resource);
    }

    public <T> T rebindNamedInstance(String name, Class<T> cls, T resource) {
        Object instance = this.getModule().bindNamedInstance(name, cls, resource);
        this.setDirty(true);
        return (T)instance;
    }

    public boolean hasInstance(Resources resources, Class cls) {
        if (cls.isAssignableFrom(Resources.class) || cls.isAssignableFrom(ResourceManager.class)) {
            return true;
        }
        if (this.getInjector() == null) {
            if (resources.getResourceManager().hasInstance(cls)) {
                return true;
            }
            return this.getModule().hasInstance(cls);
        }
        try {
            this.getInjector().getInstance(cls);
            return true;
        }
        catch (ConfigurationException ex) {
            return false;
        }
    }

    public <T> T getInstance(Resources resources, Class<T> cls) throws InstanceNotFoundException {
        if (cls.isAssignableFrom(Resources.class)) {
            return (T)resources;
        }
        if (cls.isAssignableFrom(ResourceManager.class)) {
            return (T)resources.getResourceManager();
        }
        if (this.state == State.Initial || this.isDirty()) {
            if (this.getModule().hasInstance(cls)) {
                return (T)this.getModule().getInstance(cls);
            }
            if (resources.getResourceManager().hasInstance(cls)) {
                return resources.getResourceManager().getInstance(cls);
            }
            this.createInjector(resources);
        }
        try {
            return (T)this.getInjector().getInstance(cls);
        }
        catch (ConfigurationException ex) {
            throw new InstanceNotFoundException("No instance for class " + cls.getName() + ". Use newInstance if you meant to create an instance", ex);
        }
    }

    static enum State {
        Initial,
        Open,
        Committed,
        Aborted;

    }
}

