/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import com.google.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.resources.AfterCommit;
import net.e6tech.elements.common.resources.BindClass;
import net.e6tech.elements.common.resources.Binding;
import net.e6tech.elements.common.resources.Configurator;
import net.e6tech.elements.common.resources.Injectable;
import net.e6tech.elements.common.resources.InjectionModule;
import net.e6tech.elements.common.resources.InstanceNotFoundException;
import net.e6tech.elements.common.resources.OnAbort;
import net.e6tech.elements.common.resources.OnClosed;
import net.e6tech.elements.common.resources.OnCommit;
import net.e6tech.elements.common.resources.OnOpen;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.resources.ResourcePool;
import net.e6tech.elements.common.resources.ResourceProvider;
import net.e6tech.elements.common.resources.ResourcesState;
import net.e6tech.elements.common.resources.Retry;
import net.e6tech.elements.common.resources.Transactional;
import net.e6tech.elements.common.resources.plugin.Plugin;
import net.e6tech.elements.common.resources.plugin.PluginManager;
import net.e6tech.elements.common.resources.plugin.PluginPath;
import net.e6tech.elements.common.util.ExceptionMapper;

@BindClass(value=Resources.class)
public class Resources
implements AutoCloseable,
ResourcePool {
    private static Logger logger = Logger.getLogger(Resources.class);
    private static final Map<Class, ClassInjectionInfo> injections = new Hashtable<Class, ClassInjectionInfo>();
    private static final Map<Class<? extends Annotation>, Annotation> emptyAnnotations = Collections.unmodifiableMap(new HashMap());
    private static final List<ResourceProvider> emptyResourceProviders = Collections.unmodifiableList(new ArrayList());
    @Inject
    private ResourceManager resourceManager;
    @Inject(optional=true)
    private Retry retry;
    protected ResourcesState state = new ResourcesState();
    protected Configurator configurator = new Configurator();
    private List<ResourceProvider> externalResourceProviders;
    private Consumer<? extends Resources> preOpen;
    private List<Replay<? extends Resources, ?>> unitOfWork = new LinkedList();
    Object lastResult;
    boolean submitting = false;

    protected Resources() {
        this.getModule().bindInstance(this.getClass(), this);
    }

    void setPreOpen(Consumer<? extends Resources> preOpen) {
        this.preOpen = preOpen;
    }

    public synchronized boolean isCommitted() {
        return this.state.getState() == ResourcesState.State.Committed;
    }

    public synchronized boolean isOpen() {
        return this.state.getState() == ResourcesState.State.Open;
    }

    public synchronized boolean isAborted() {
        return this.state.getState() == ResourcesState.State.Aborted;
    }

    public synchronized boolean isClosed() {
        return !this.isOpen();
    }

    public synchronized boolean isDiscarded() {
        return this.resourceManager == null;
    }

    List<ResourceProvider> getExternalResourceProviders() {
        if (this.externalResourceProviders == null) {
            return emptyResourceProviders;
        }
        return this.externalResourceProviders;
    }

    void setExternalResourceProviders(List<ResourceProvider> externalResourceProviders) {
        this.externalResourceProviders = externalResourceProviders;
    }

    private List<ResourceProvider> getResourceProviders() {
        return this.state.getResourceProviders();
    }

    public synchronized void addResourceProvider(ResourceProvider resourceProvider) {
        this.getResourceProviders().add(resourceProvider);
        if (this.isOpen()) {
            resourceProvider.onOpen(this);
        }
        if (this.isCommitted()) {
            resourceProvider.onCommit(this);
        }
        if (this.isCommitted()) {
            resourceProvider.afterCommit(this);
        }
        if (this.isAborted()) {
            resourceProvider.onAbort(this);
        }
    }

    public void onCommit(OnCommit onCommit) {
        this.addResourceProvider(onCommit);
    }

    public void onCommit(Runnable runnable) {
        OnCommit on = res -> runnable.run();
        this.onCommit(on);
    }

    public void afterCommit(AfterCommit afterCommit) {
        this.addResourceProvider(afterCommit);
    }

    public void afterCommit(Runnable runnable) {
        AfterCommit after = res -> runnable.run();
        this.afterCommit(after);
    }

    public synchronized void onOpen(OnOpen onOpen) {
        this.addResourceProvider(onOpen);
    }

    public synchronized void onOpen(Runnable runnable) {
        OnOpen on = res -> runnable.run();
        this.onOpen(on);
    }

    public synchronized void onAbort(OnAbort onAbort) {
        this.addResourceProvider(onAbort);
    }

    public synchronized void onAbort(Runnable runnable) {
        OnAbort on = res -> runnable.run();
        this.onAbort(on);
    }

    public synchronized void onClosed(OnClosed onClosed) {
        this.addResourceProvider(onClosed);
    }

    public synchronized void onClosed(Runnable runnable) {
        OnClosed on = res -> runnable.run();
        this.onClosed(on);
    }

    public synchronized boolean remove(ResourceProvider provider) {
        return this.getResourceProviders().remove(provider);
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public <S, T extends Plugin> T getPlugin(Class<S> c1, String n1, Class<T> c2, Object ... args) {
        return this.getPlugin(PluginPath.of(c1, n1).and(c2), args);
    }

    public <R, S, T extends Plugin> T getPlugin(Class<R> c1, String n1, Class<S> c2, String n2, Class<T> c3, Object ... args) {
        return this.getPlugin(PluginPath.of(c1, n1).and(c2, n2).and(c3), args);
    }

    public <T extends Plugin> T getPlugin(PluginPath<T> path, Object ... args) {
        PluginManager plugin = this.getInstance(PluginManager.class);
        return plugin.from(this).get(path, args);
    }

    public <T> T getVariable(String variable) {
        return this.resourceManager.getVariable(variable);
    }

    public InjectionModule getModule() {
        return this.state.getModule();
    }

    public void addModule(InjectionModule module) {
        this.state.addModule(module);
    }

    public <T> Binding<T> getBinding(Class<T> cls) {
        Binding<T> boundInstance = new Binding<T>(this, cls);
        return boundInstance;
    }

    public <T> T tryBind(Class<T> cls, Callable<T> callable) {
        return this.state.tryBind(this, cls, callable);
    }

    public <T> boolean isBound(Class<T> cls) {
        return this.getModule().getBoundInstance(cls) != null;
    }

    @Override
    public <T> T bind(Class<T> cls, T resource) {
        return this.state.bind(this, cls, resource);
    }

    @Override
    public <T> T rebind(Class<T> cls, T resource) {
        return this.state.rebind(this, cls, resource);
    }

    @Override
    public <T> T unbind(Class<T> cls) {
        return this.state.unbind(cls);
    }

    @Override
    public void bindClass(Class cls, Class service) {
        this.state.bindClass(cls, service);
    }

    @Override
    public <T> T bindNamedInstance(String name, Class<T> cls, T resource) {
        return this.state.bindNamedInstance(name, cls, resource);
    }

    @Override
    public <T> T rebindNamedInstance(String name, Class<T> cls, T resource) {
        return this.state.rebindNamedInstance(name, cls, resource);
    }

    public <T> T getBoundNamedInstance(String name) {
        return this.getModule().getBoundNamedInstance(name);
    }

    @Override
    public <T> T inject(T object) {
        return this.inject(object, new HashSet<Object>());
    }

    private <T> T inject(T object, Set<Object> seen) {
        if (object == null) {
            return null;
        }
        if (seen.contains(System.identityHashCode(object))) {
            return object;
        }
        T injected = this.state.inject(this, object);
        seen.add(System.identityHashCode(object));
        ClassInjectionInfo info = injections.get(object.getClass());
        if (info == null) {
            info = new ClassInjectionInfo();
            Class<?> cls = object.getClass();
            Package p = cls.getPackage();
            if (p == null || !p.getName().startsWith("java.") && !p.getName().startsWith("javax.")) {
                while (cls != null && !cls.equals(Object.class)) {
                    for (Field f : cls.getDeclaredFields()) {
                        if (f.getAnnotation(Injectable.class) == null && f.getType().getAnnotation(Injectable.class) == null) continue;
                        f.setAccessible(true);
                        info.addInjectableField(f);
                    }
                    cls = cls.getSuperclass();
                }
            }
            injections.put(object.getClass(), info);
        }
        for (Field f : info.getInjectableFields()) {
            try {
                Object injectField = f.get(object);
                if (injectField == null) continue;
                this.inject(injectField, seen);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return injected;
    }

    public boolean hasInstance(Class cls) {
        return this.state.hasInstance(this, cls);
    }

    public <T> T getInstance(Class<T> cls) throws InstanceNotFoundException {
        return this.state.getInstance(this, cls);
    }

    public <T> T getInstance(Class<T> cls, Supplier<T> call) {
        try {
            return this.state.getInstance(this, cls);
        }
        catch (InstanceNotFoundException ex) {
            return call.get();
        }
    }

    public Configurator configurator() {
        return this.configurator;
    }

    public void configure(Configurator configurator) {
        this.configurator.putAll(configurator);
    }

    public synchronized void onOpen() {
        if (!this.isOpen()) {
            this.state.setState(ResourcesState.State.Open);
            for (ResourceProvider resourceProvider : this.state.getResourceProviders()) {
                resourceProvider.onOpen(this);
            }
            this.state.onOpen(this);
        }
    }

    protected <Res extends Resources, R> R replay(Throwable th, Replay<Res, R> replay) {
        if (this.isAborted() || this.retry == null) {
            this.log("Aborting due to exception", th);
            if (!this.isAborted()) {
                this.abort();
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new RuntimeException(th);
        }
        try {
            return (R)this.retry.retry(th, () -> {
                StringBuilder builder = new StringBuilder();
                builder.append("Resources retrying due to error: ").append(ExceptionMapper.unwrap(th).getClass()).append(", message: ").append(th.getMessage());
                Reflection.printStackTrace(builder, "    ", 2, 8);
                logger.warn(builder.toString());
                try {
                    this.abort();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Resources retryResources = this.resourceManager.open(null, this.preOpen);
                this.state = retryResources.state;
                Iterator<Replay<Resources, ?>> iterator = this.unitOfWork.iterator();
                while (iterator.hasNext()) {
                    Object ret = iterator.next().replay(this);
                    if (iterator.hasNext()) continue;
                    this.lastResult = ret;
                }
                return replay.replay(this);
            });
        }
        catch (Throwable th2) {
            this.log("Aborting due to exception", th2);
            this.abort();
            if (th2 instanceof RuntimeException) {
                throw (RuntimeException)th2;
            }
            throw new RuntimeException(th2);
        }
    }

    public synchronized <Res extends Resources> void submit(Transactional.ConsumerWithException<Res> work) {
        this.play(new Replay(work));
    }

    public synchronized <Res extends Resources, R> R submit(Transactional.FunctionWithException<Res, R> work) {
        return this.play(new Replay<Res, R>(work));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Res extends Resources, R> R play(Replay<Res, R> replay) {
        R ret = null;
        boolean topLevel = !this.submitting;
        this.submitting = true;
        try {
            try {
                ret = replay.replay(this);
            }
            catch (Throwable th) {
                ret = this.replay(th, replay);
            }
            this.lastResult = ret;
        }
        finally {
            if (topLevel) {
                this.submitting = false;
                this.unitOfWork.add(replay);
            }
        }
        return ret;
    }

    private void log(String msg, Throwable th) {
        Provision provision = this.resourceManager.getInstance(Provision.class);
        provision.log(logger, msg, th);
    }

    public synchronized <R> R commit() {
        Object ret = null;
        try {
            ret = this._commit();
        }
        catch (Throwable th) {
            ret = this.replay(th, new Replay<Resources, Object>(res -> this._commit()));
        }
        finally {
            if (this.isCommitted()) {
                this.cleanup();
                this.state.setState(ResourcesState.State.Committed);
            }
        }
        return (R)ret;
    }

    private <R> R _commit() {
        ResourceProvider resourceProvider;
        Object ret = null;
        if (this.resourceManager == null) {
            return null;
        }
        if (this.isAborted()) {
            return (R)this.lastResult;
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Already closed");
        }
        for (int i = 0; i < this.state.getResourceProviders().size(); ++i) {
            resourceProvider = this.state.getResourceProviders().get(i);
            resourceProvider.onCommit(this);
            if (!this.isAborted()) continue;
            return (R)this.lastResult;
        }
        for (ResourceProvider p : this.getExternalResourceProviders()) {
            p.onCommit(this);
        }
        for (int i = 0; i < this.state.getResourceProviders().size(); ++i) {
            resourceProvider = this.state.getResourceProviders().get(i);
            try {
                resourceProvider.afterCommit(this);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.state.setState(ResourcesState.State.Committed);
        ret = this.lastResult;
        return (R)ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void abort() {
        try {
            if (this.resourceManager == null) {
                return;
            }
            if (!this.isAborted()) {
                for (int i = 0; i < this.state.getResourceProviders().size(); ++i) {
                    ResourceProvider resourceProvider = this.state.getResourceProviders().get(i);
                    try {
                        resourceProvider.onAbort(this);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                for (ResourceProvider p : this.getExternalResourceProviders()) {
                    try {
                        p.onAbort(this);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        finally {
            this.cleanup();
            this.state.setState(ResourcesState.State.Aborted);
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.isOpen()) {
            return;
        }
        if (!this.isAborted()) {
            this.commit();
        } else {
            this.abort();
        }
    }

    synchronized void discard() {
        this.resourceManager = null;
        this.state.discard();
    }

    private void cleanup() {
        try {
            for (ResourceProvider resourceProvider : this.state.getResourceProviders()) {
                resourceProvider.onClosed(this);
            }
            for (ResourceProvider p : this.getExternalResourceProviders()) {
                p.onClosed(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.state.cleanup();
        this.getModule().bindInstance(Resources.class, this);
        this.lastResult = null;
    }

    public <T extends Provision> T provision() {
        return (T)this.getInstance(Provision.class);
    }

    private static class ClassInjectionInfo {
        private static final List<Field> emptyFields = Collections.unmodifiableList(new ArrayList());
        private List<Field> injectableFields = emptyFields;

        private ClassInjectionInfo() {
        }

        void addInjectableField(Field field) {
            if (this.injectableFields == emptyFields) {
                this.injectableFields = new ArrayList<Field>();
            }
            this.injectableFields.add(field);
        }

        List<Field> getInjectableFields() {
            return this.injectableFields;
        }
    }

    private static class Replay<Res, R> {
        Transactional.ConsumerWithException<Res> consumer;
        Transactional.FunctionWithException<Res, R> function;

        Replay(Transactional.ConsumerWithException<Res> work) {
            this.consumer = work;
        }

        Replay(Transactional.FunctionWithException<Res, R> work) {
            this.function = work;
        }

        R replay(Res res) throws Throwable {
            if (this.consumer != null) {
                this.consumer.accept(res);
                return null;
            }
            return this.function.apply(res);
        }
    }
}

