/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.cache;

import com.google.inject.Inject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import javax.cache.Cache;
import net.e6tech.elements.common.cache.CachePool;
import net.e6tech.elements.common.reflection.Reflection;

public abstract class CacheFacade<K, V> {
    @Inject(optional=true)
    protected CachePool pool;
    protected String name;
    protected Class keyClass;
    protected Class valueClass;
    private boolean storeByValue = false;
    Cache<K, V> cache;

    public CacheFacade() {
        this(null);
    }

    public CacheFacade(long expiry) {
        this(null, expiry);
    }

    public CacheFacade(String name) {
        this(Reflection.getCallingClass(), name);
    }

    public CacheFacade(String name, long expiry) {
        this(Reflection.getCallingClass(), name);
        this.initPool(expiry);
    }

    public CacheFacade(Class cls, String name) {
        String clsName;
        int last;
        Type genericSuper = this.getClass().getGenericSuperclass();
        if (genericSuper instanceof ParameterizedType) {
            ParameterizedType parametrizedType = (ParameterizedType)genericSuper;
            Type type = parametrizedType.getActualTypeArguments()[0];
            if (type instanceof Class) {
                this.keyClass = (Class)type;
            } else if (type instanceof ParameterizedType) {
                this.keyClass = (Class)((ParameterizedType)type).getRawType();
            }
            type = parametrizedType.getActualTypeArguments()[1];
            if (type instanceof Class) {
                this.valueClass = (Class)type;
            } else if (type instanceof ParameterizedType) {
                this.valueClass = (Class)((ParameterizedType)type).getRawType();
            }
        }
        if ((last = (clsName = cls.getName()).lastIndexOf(36)) > 0) {
            clsName = clsName.substring(0, last);
        }
        this.name = name != null ? clsName + "." + name : clsName;
    }

    public CacheFacade<K, V> initPool(long expiry) {
        if (this.pool == null) {
            this.pool = new CachePool();
            this.pool.setExpiry(expiry);
            this.pool.setStoreByValue(this.storeByValue);
        }
        return this;
    }

    public CacheFacade<K, V> initPool() {
        return this.initPool(900000L);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CachePool getPool() {
        return this.pool;
    }

    public void setPool(CachePool pool) {
        this.pool = pool;
    }

    public boolean isStoreByValue() {
        return this.storeByValue;
    }

    public void setStoreByValue(boolean storeByValue) {
        this.storeByValue = storeByValue;
    }

    public V get(K key) {
        return (V)this.getCache().get(key);
    }

    public V get(K key, Callable<V> callable) {
        Cache<K, V> cache = this.getCache();
        Object value = cache.get(key);
        if (value == null) {
            try {
                value = callable.call();
                cache.put(key, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (V)value;
    }

    public boolean remove(K key) {
        Cache<K, V> cache = this.getCache();
        return cache.remove(key);
    }

    public void put(K key, V value) {
        this.getCache().put(key, value);
    }

    protected synchronized Cache<K, V> getCache() {
        if (this.cache != null) {
            return this.cache;
        }
        if (this.pool == null) {
            this.pool = new CachePool();
        }
        this.cache = this.pool.getCache(this.name, this.keyClass, this.valueClass);
        return this.cache;
    }
}

