/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import java.util.function.Consumer;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Atom;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.script.AbstractScriptBase;

public abstract class ResourceManagerScript
extends AbstractScriptBase<ResourceManager> {
    Logger logger = Logger.getLogger();

    public Object invokeMethod(String name, Object args) {
        try {
            return this.getMetaClass().invokeMethod((Object)this, name, args);
        }
        catch (MissingMethodException ex) {
            if (ex.getArguments().length > 0 && ex.getArguments()[0] instanceof Closure) {
                Closure closure = (Closure)ex.getArguments()[0];
                if (closure.getDelegate() instanceof Closure) {
                    Closure outerClosure = (Closure)closure.getDelegate();
                    if (outerClosure.getDelegate() instanceof Atom) {
                        Atom atom = (Atom)outerClosure.getDelegate();
                        Object value = atom.get(name);
                        if (value == null) {
                            this.logger.warn("component(" + atom.getName() + ") trying to insert Closure with no instance named " + name);
                        }
                        return atom.put(name, (Object)closure);
                    }
                    throw ex;
                }
                throw ex;
            }
            throw ex;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public void bindClass(Class a, Class b) {
        ResourceManager resourceManager = (ResourceManager)this.getVariable("resourceManager");
        resourceManager.bindClass(a, b);
    }

    public <T> T bindNamedInstance(String name, Class<T> a, T b) {
        ResourceManager resourceManager = (ResourceManager)this.getVariable("resourceManager");
        return resourceManager.bindNamedInstance(name, a, b);
    }

    public <T> T bindNamedInstance(String name, T b) {
        ResourceManager resourceManager = (ResourceManager)this.getVariable("resourceManager");
        return (T)resourceManager.bindNamedInstance(name, b.getClass(), b);
    }

    public <T> T registerBean(String name, Object instance) {
        return ((ResourceManager)this.getShell()).registerBean(name, instance);
    }

    public void unregisterBean(String name) {
        ((ResourceManager)this.getShell()).unregisterBean(name);
    }

    public <T> T getBean(String name) {
        return ((ResourceManager)this.getShell()).getBean(name);
    }

    public Atom atom(Closure closure) {
        return this.atom(null, closure);
    }

    public Atom prototype(String name, Closure closure) {
        Consumer<Atom> consumer = this.atomConsumer(closure);
        Atom atom = ((ResourceManager)this.getShell()).createAtom(name, consumer, null, true);
        return atom;
    }

    public Atom prototype(String name, String prototypePath, Closure closure) {
        Atom prototype = (Atom)((ResourceManager)this.getShell()).exec(prototypePath);
        Consumer<Atom> consumer = this.atomConsumer(closure);
        Atom atom = ((ResourceManager)this.getShell()).createAtom(name, consumer, prototype, true);
        return atom;
    }

    public Atom atom(String name, Closure closure) {
        Consumer<Atom> consumer = this.atomConsumer(closure);
        Atom atom = ((ResourceManager)this.getShell()).createAtom(name, consumer, null, false);
        return atom;
    }

    public Atom atom(String name, String prototypePath, Closure closure) {
        Atom prototype = (Atom)((ResourceManager)this.getShell()).exec(prototypePath);
        Consumer<Atom> consumer = this.atomConsumer(closure);
        Atom atom = ((ResourceManager)this.getShell()).createAtom(name, consumer, prototype, false);
        return atom;
    }

    private Consumer<Atom> atomConsumer(Closure closure) {
        Consumer<Atom> consumer = atom -> {
            Closure clonedClosure = closure.rehydrate(atom, closure.getOwner(), closure.getOwner());
            clonedClosure.setResolveStrategy(1);
            clonedClosure.call(atom);
            ((ResourceManager)this.getShell()).addCleanup(() -> {
                clonedClosure.setDelegate(null);
                Object owner = clonedClosure.getOwner();
                if (owner != null && owner instanceof Closure) {
                    ((Closure)owner).setDelegate(null);
                }
            });
        };
        return consumer;
    }
}

