/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.name.Names;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.BindClass;

public class InjectionModule
extends AbstractModule
implements Cloneable {
    private static Logger logger = Logger.getLogger();
    private Map<Type, Entry> bindInstances = new HashMap<Type, Entry>();
    private Map<String, Entry> bindNamedInstances = new HashMap<String, Entry>();
    private Map<Type, Class> bindClasses = new HashMap<Type, Class>();
    private Map<Type, InjectionListener> listeners = new LinkedHashMap<Type, InjectionListener>();

    public InjectionModule clone() {
        try {
            InjectionModule clone = (InjectionModule)super.clone();
            clone.bindInstances = (Map)((HashMap)this.bindInstances).clone();
            clone.bindNamedInstances = (Map)((HashMap)this.bindNamedInstances).clone();
            clone.bindClasses = (Map)((HashMap)this.bindClasses).clone();
            clone.listeners = (Map)((LinkedHashMap)this.listeners).clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private static Type[] getBindClass(Class cls) {
        Class prev = cls;
        Class bindClass = cls;
        for (Class c = cls; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
            BindClass bind = c.getAnnotation(BindClass.class);
            if (bind != null) {
                if (bind.generics()) {
                    return new Type[]{cls, prev.getGenericSuperclass()};
                }
                bindClass = bind.value();
                break;
            }
            prev = c;
        }
        if (bindClass.getGenericSuperclass() instanceof ParameterizedType && bindClass.getTypeParameters().length == 0 && bindClass.isAnonymousClass()) {
            return new Type[]{cls, bindClass.getGenericSuperclass()};
        }
        if (bindClass.equals(cls)) {
            return new Type[]{cls};
        }
        return new Type[]{cls, bindClass};
    }

    public synchronized Object bindInstance(Class cls, Object instance) {
        instance = this.newInstance(instance);
        Type[] types = InjectionModule.getBindClass(cls);
        Entry entry = new Entry(types, instance);
        for (Type type : types) {
            this.bindInstances.put(type, entry);
        }
        return instance;
    }

    public synchronized Object unbindInstance(Class cls) {
        Type[] types = InjectionModule.getBindClass(cls);
        Entry entry = null;
        for (Type type : types) {
            entry = this.bindInstances.remove(type);
        }
        if (entry != null) {
            return entry.instance;
        }
        return null;
    }

    public synchronized Object bindNamedInstance(String name, Class cls, Object instance) {
        instance = this.newInstance(instance);
        this.bindNamedInstances.put(name, new Entry(InjectionModule.getBindClass(cls), instance));
        return instance;
    }

    private Object newInstance(Object instance) {
        if (instance instanceof Class) {
            try {
                instance = ((Class)instance).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw logger.runtimeException(e);
            }
        }
        return instance;
    }

    public synchronized <T> T getBoundNamedInstance(String name) {
        Entry entry = this.bindNamedInstances.get(name);
        if (entry == null) {
            return null;
        }
        return (T)entry.instance;
    }

    public synchronized <T> T getBoundInstance(Class<T> cls) {
        Entry entry = this.bindInstances.get(cls);
        if (entry == null) {
            return null;
        }
        return (T)entry.instance;
    }

    public synchronized boolean hasInstance(Class cls) {
        return this.bindInstances.containsKey(cls);
    }

    public synchronized Object getInstance(Class cls) {
        Entry entry = this.bindInstances.get(cls);
        if (entry == null) {
            return null;
        }
        return entry.instance;
    }

    public synchronized void bindClass(Class cls, Class service) {
        Type[] types;
        for (Type type : types = InjectionModule.getBindClass(cls)) {
            this.bindClasses.put(type, service);
        }
    }

    public synchronized Class getBoundClass(Class cls) {
        return this.bindClasses.get(cls);
    }

    public synchronized boolean hasBinding(Class cls) {
        return this.bindInstances.containsKey(cls) || this.bindClasses.containsKey(cls);
    }

    void bindListener(Class cls, InjectionListener listener) {
        Type[] types;
        for (Type type : types = InjectionModule.getBindClass(cls)) {
            this.listeners.put(type, listener);
        }
    }

    boolean hasListener(Class cls) {
        return this.listeners.containsKey(cls);
    }

    public synchronized void add(InjectionModule module) {
        BiConsumer<Map, Map> copy = (from, to) -> {
            for (Object key : from.keySet()) {
                if (to.containsKey(key)) continue;
                to.put(key, from.get(key));
            }
        };
        copy.accept(module.bindClasses, this.bindClasses);
        copy.accept(module.bindNamedInstances, this.bindNamedInstances);
        copy.accept(module.bindInstances, this.bindInstances);
        copy.accept(module.listeners, this.listeners);
    }

    public Injector createInjector(InjectionModule ... additional) {
        ArrayList<InjectionModule> moduleList = new ArrayList<InjectionModule>();
        if (additional != null) {
            for (InjectionModule m : additional) {
                moduleList.add(m);
            }
        }
        return this.createInjector(moduleList);
    }

    public Injector createInjector(Iterable<? extends InjectionModule> additional) {
        ArrayList<InjectionModule> moduleList = new ArrayList<InjectionModule>();
        moduleList.add(this);
        additional.forEach(m -> moduleList.add((InjectionModule)m));
        Collections.reverse(moduleList);
        HashMap<Type, Entry> bindInstances = new HashMap<Type, Entry>();
        HashMap<String, Entry> bindNamedInstances = new HashMap<String, Entry>();
        HashMap<Type, Class> bindClasses = new HashMap<Type, Class>();
        for (InjectionModule m2 : moduleList) {
            bindInstances.putAll(m2.bindInstances);
            bindNamedInstances.putAll(m2.bindNamedInstances);
            bindClasses.putAll(m2.bindClasses);
        }
        InjectionModule resultingModule = new InjectionModule();
        resultingModule.bindInstances = bindInstances;
        resultingModule.bindNamedInstances = bindNamedInstances;
        resultingModule.bindClasses = bindClasses;
        resultingModule.listeners = this.listeners;
        Injector injector = Guice.createInjector((Module[])new Module[]{resultingModule});
        this.inject(injector);
        return injector;
    }

    private void inject(Injector injector) {
        Entry entry;
        for (String name : this.bindNamedInstances.keySet()) {
            entry = this.bindNamedInstances.get(name);
            if (entry.instance == null) continue;
            injector.injectMembers(entry.instance);
        }
        for (Type type : this.bindInstances.keySet()) {
            entry = this.bindInstances.get(type);
            if (entry == null || entry.instance == null) continue;
            injector.injectMembers(entry.instance);
        }
    }

    protected synchronized void configure() {
        Entry entry;
        this.binder().requireExplicitBindings();
        for (Type type : this.bindClasses.keySet()) {
            if (type instanceof Class) {
                this.bind((Class)type).to(this.bindClasses.get(type));
                continue;
            }
            this.bind(TypeLiteral.get((Type)type)).to(this.bindClasses.get(type));
        }
        for (String name : this.bindNamedInstances.keySet()) {
            entry = this.bindNamedInstances.get(name);
            for (Type type : entry.types) {
                if (type instanceof Class) {
                    this.bind((Class)type).annotatedWith((Annotation)Names.named((String)name)).toProvider((Provider)new InstanceProvider(entry.instance));
                    continue;
                }
                this.bind(TypeLiteral.get((Type)type)).annotatedWith((Annotation)Names.named((String)name)).toProvider((Provider)new InstanceProvider(entry.instance));
            }
        }
        for (Type type : this.bindInstances.keySet()) {
            entry = this.bindInstances.get(type);
            try {
                if (type instanceof Class) {
                    if (entry != null) {
                        if (entry.instance != null) {
                            this.bind((Class)type).toProvider((Provider)new InstanceProvider(entry.instance));
                            continue;
                        }
                        this.bind((Class)type).toProvider(() -> null);
                        continue;
                    }
                    this.bind((Class)type).toProvider(() -> null);
                    continue;
                }
                if (entry != null) {
                    if (entry.instance != null) {
                        this.bind(TypeLiteral.get((Type)type)).toProvider((Provider)new InstanceProvider(entry.instance));
                        continue;
                    }
                    this.bind(TypeLiteral.get((Type)type)).toProvider((Provider)new InstanceProvider(null));
                    continue;
                }
                this.bind(TypeLiteral.get((Type)type)).toProvider((Provider)new InstanceProvider(null));
            }
            catch (Throwable th) {
                logger.error("Cannot bind " + type + " to " + entry);
                throw th;
            }
        }
        for (final Type key : this.listeners.keySet()) {
            final InjectionListener listener = this.listeners.get(key);
            TypeListener lis = new TypeListener(){

                public void hear(TypeLiteral type, TypeEncounter encounter) {
                    encounter.register(listener);
                }
            };
            this.bindListener((Matcher)new AbstractMatcher<TypeLiteral>(){

                public boolean matches(TypeLiteral typeLiteral) {
                    return typeLiteral.getType().equals(key);
                }
            }, lis);
        }
    }

    private class Entry {
        Type[] types;
        Object instance;

        Entry(Type[] c, Object i) {
            this.types = c;
            this.instance = i;
        }
    }

    private static class InstanceProvider
    implements Provider {
        Object instance;

        InstanceProvider(Object instance) {
            this.instance = instance;
        }

        public Object get() {
            return this.instance;
        }
    }
}

