/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import java.lang.reflect.Proxy;
import net.e6tech.elements.common.resources.Resources;

public interface ResourceProvider {
    public static ResourceProvider wrap(String name, ResourceProvider resourceProvider) {
        return (ResourceProvider)Proxy.newProxyInstance(resourceProvider.getClass().getClassLoader(), new Class[]{ResourceProvider.class}, (proxy, method, args) -> {
            if (method.getName().equals("description") && (args == null || args.length == 0)) {
                return name;
            }
            return method.invoke((Object)resourceProvider, args);
        });
    }

    default public void onOpen(Resources resources) {
    }

    default public void onCommit(Resources resources) {
    }

    default public void afterCommit(Resources resources) {
    }

    default public void onAbort(Resources resources) {
    }

    default public void onClosed(Resources resources) {
    }

    default public void onShutdown() {
    }

    default public String description() {
        return this.getClass().getName();
    }
}

