/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.notification;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import net.e6tech.elements.common.notification.Notification;

public interface NotificationListener<T extends Notification> {
    public static <R extends Notification> NotificationListener<R> create(final String name, final Consumer<R> consumer) {
        return new NotificationListener<R>(){

            @Override
            public void onEvent(R notification) {
                consumer.accept(notification);
            }

            @Override
            public String description() {
                return name;
            }
        };
    }

    public static <R extends Notification> NotificationListener<R> create(final String name, final Class<? extends Notification>[] types, final Consumer<R> consumer) {
        return new NotificationListener<R>(){

            @Override
            public Class<? extends Notification>[] getNotificationTypes() {
                return types;
            }

            @Override
            public void onEvent(R notification) {
                consumer.accept(notification);
            }

            @Override
            public String description() {
                return name;
            }
        };
    }

    default public Class<? extends Notification>[] getNotificationTypes() {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = this.getClass().getGenericInterfaces()) {
            ParameterizedType parametrizedType;
            Type[] typeArguments;
            if (!(genericInterface instanceof ParameterizedType) || !((ParameterizedType)genericInterface).getRawType().equals(NotificationListener.class) || (typeArguments = (parametrizedType = (ParameterizedType)genericInterface).getActualTypeArguments()).length <= 0 || !(typeArguments[0] instanceof Class)) continue;
            return new Class[]{(Class)typeArguments[0]};
        }
        return new Class[0];
    }

    default public String description() {
        return this.getClass().getName();
    }

    public void onEvent(T var1);
}

