/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.actor;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.Patterns;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.e6tech.elements.common.actor.pool.Events;
import net.e6tech.elements.common.actor.pool.WorkerPool;
import net.e6tech.elements.common.notification.NotificationListener;
import net.e6tech.elements.common.notification.ShutdownNotification;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.Resources;
import scala.compat.java8.FutureConverters;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public class Genesis
implements Initializable,
NotificationListener<ShutdownNotification> {
    public static final String WorkerPoolDispatcher = "worker-pool-dispatcher";
    private String name;
    private String configuration;
    private ActorSystem system;
    private ActorRef workerPool;
    private int initialCapacity = 1;
    private int maxCapacity = Integer.MAX_VALUE;
    private long idleTimeout = 10000L;
    private long timeout = 5000L;

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        if (idleTimeout < 0L) {
            throw new IllegalArgumentException();
        }
        this.idleTimeout = idleTimeout;
    }

    @Override
    public void initialize(Resources resources) {
        if (this.name == null) {
            throw new IllegalStateException("name is null");
        }
        Config config = null;
        config = this.configuration != null ? ConfigFactory.parseString((String)this.configuration) : ConfigFactory.defaultApplication();
        this.initialize(config);
    }

    public void initialize(Config config) {
        if (this.name == null) {
            throw new IllegalStateException("name is null");
        }
        if (config == null) {
            config = ConfigFactory.defaultApplication();
        }
        if (!config.hasPath(WorkerPoolDispatcher)) {
            config = config.withFallback((ConfigMergeable)ConfigFactory.parseString((String)"worker-pool-dispatcher {\n  type = Dispatcher\n  thread-pool-executor {\n      keep-alive-time = 60s\n      core-pool-size-min = 8\n      core-pool-size-factor = 5.0\n      # unbounded so that max-pool-size-factor has no effect.\n      task-queue-size = -1\n      allow-core-timeout = on\n    }\n  throughput = 1\n}"));
        }
        this.system = ActorSystem.create((String)this.name, (Config)config);
        this.workerPool = WorkerPool.newPool(this.system, this.initialCapacity, this.maxCapacity, this.idleTimeout);
    }

    @Override
    public void onEvent(ShutdownNotification notification) {
        try {
            Await.ready((Awaitable)this.system.terminate(), (Duration)Duration.create((long)30L, (TimeUnit)TimeUnit.SECONDS));
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public ActorRef getWorkerPool() {
        return this.workerPool;
    }

    public void setWorkerPool(ActorRef workerPool) {
        this.workerPool = workerPool;
    }

    public ActorSystem getSystem() {
        return this.system;
    }

    public CompletionStage<Void> async(Runnable runnable) {
        return this.async(runnable, this.getTimeout());
    }

    public CompletionStage<Void> async(Runnable runnable, long timeout) {
        Future future = Patterns.ask((ActorRef)this.workerPool, (Object)runnable, (long)timeout);
        return FutureConverters.toJava((Future)future).thenAcceptAsync(ret -> {});
    }

    public <R> CompletionStage<R> async(Callable<R> callable) {
        return this.async(callable, this.getTimeout());
    }

    public <R> CompletionStage<R> async(Callable<R> callable, long timeout) {
        Future future = Patterns.ask((ActorRef)this.workerPool, callable, (long)timeout);
        return FutureConverters.toJava((Future)future).thenApplyAsync(ret -> {
            Events.Response response = (Events.Response)ret;
            return response.getValue();
        });
    }
}

