/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingPropertyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.script.ScriptException;
import net.e6tech.elements.common.launch.LaunchListener;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.notification.Notification;
import net.e6tech.elements.common.notification.NotificationListener;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.resources.BeanLifecycle;
import net.e6tech.elements.common.resources.BeanListener;
import net.e6tech.elements.common.resources.ClassBeanListener;
import net.e6tech.elements.common.resources.Configuration;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.InstanceNotFoundException;
import net.e6tech.elements.common.resources.NamedBeanListener;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.resources.ResourceProvider;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.Startable;

public class Atom
implements Map<String, Object> {
    private static Logger logger = Logger.getLogger();
    private static final String WAIT_FOR = "waitFor";
    private static final String PRE_INIT = "preInit";
    private static final String POST_INIT = "postInit";
    private static final String LAUNCHED = "launched";
    private static final String AFTER = "after";
    private static final String CONFIGURATION = "configuration";
    private static final String EXEC = "exec";
    private static final String NAME = "name";
    private static final String RESOURCES = "resources";
    private static final String RESOURCE_MANAGER = "resourceManager";
    private ResourceManager resourceManager;
    private Resources resources;
    private Map<String, Object> boundInstances = new LinkedHashMap<String, Object>();
    private Configuration configuration;
    private List<Configurable> configurables = new ArrayList<Configurable>();
    private String name;
    private Map<String, BiConsumer<String, Object>> directives = new HashMap<String, BiConsumer<String, Object>>();
    private BeanLifecycle beanLifecycle;
    private boolean prototype = false;

    Atom(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.beanLifecycle = resourceManager.getBeanLifecycle();
        this.resources = resourceManager.newResources();
        BiConsumer<String, Object> put = (key, value) -> this.boundInstances.put((String)key, value);
        this.directives.put(CONFIGURATION, (key, value) -> {
            if (value != null) {
                this.configuration = new Configuration(resourceManager.getScripting().getProperties());
                this.configuration.load(value.toString());
                this.resources.configurator.putAll(this.configuration);
            }
        });
        this.directives.put(WAIT_FOR, (key, value) -> new MyBeanListener().invokeMethod((String)key, new Object[]{value}));
        this.directives.put(PRE_INIT, put);
        this.directives.put(POST_INIT, put);
        this.directives.put(AFTER, (key, value) -> this.runAfter(value));
        this.directives.put(LAUNCHED, (key, value) -> this.runLaunched(value));
        this.directives.put(EXEC, (key, value) -> {
            try {
                if (value instanceof String) {
                    resourceManager.exec(value.toString());
                } else if (value instanceof List) {
                    resourceManager.exec(((List)value).toArray(new Object[0]));
                }
            }
            catch (RuntimeException e) {
                throw new NestedScriptException(e.getCause());
            }
        });
    }

    public Atom(ResourceManager resourceManager, Atom prototype) {
        this(resourceManager);
        if (prototype == null) {
            return;
        }
        if (!prototype.isPrototype()) {
            throw new IllegalArgumentException("Atom named " + prototype.getName() + " is not a prototype.");
        }
        this.resources = prototype.resources;
        this.boundInstances = prototype.boundInstances;
    }

    public <T> T bind(Class<T> cls, T resource) {
        return this.resources.bind(cls, resource);
    }

    public <T> T resourceManagerBind(Class<T> cls, T resource) {
        this.resources.unbind(cls);
        return this.resourceManager.bind(cls, resource);
    }

    public boolean isPrototype() {
        return this.prototype;
    }

    public void setPrototype(boolean prototype) {
        this.prototype = prototype;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void bindInitialContext(String key, Object value) {
        try {
            new InitialContext().bind(key, value);
        }
        catch (NamingException e) {
            throw logger.runtimeException(e);
        }
    }

    public Map<String, Object> getConfiguration() {
        if (this.configuration == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.configuration);
    }

    public void configure(Object obj) {
        this.configure(obj, null);
    }

    public void configure(Object obj, String prefix) {
        if (obj instanceof NotificationListener) {
            Class<Notification>[] notificationTypes;
            NotificationListener listener = (NotificationListener)obj;
            for (Class<Notification> notificationType : notificationTypes = listener.getNotificationTypes()) {
                this.resourceManager.getNotificationCenter().addNotificationListener(notificationType, listener);
            }
        }
        if (this.configuration == null) {
            this.configurables.add(new Configurable(obj, prefix));
            return;
        }
        if (obj != null) {
            this.boundInstances.put(prefix, obj);
        }
        this.configuration.configure(obj, prefix, str -> {
            try {
                Closure closure = (Closure)this.resourceManager.getScripting().eval("{ it ->" + str + " }");
                closure.setDelegate((Object)this);
                closure.setResolveStrategy(1);
                return closure.call(obj);
            }
            catch (MissingPropertyException e) {
                return null;
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        }, (value, toType, instance) -> {
            Package p;
            if (instance != null && ((p = instance.getClass().getPackage()) == null || !p.getName().startsWith("java.") && !p.getName().startsWith("javax."))) {
                this.resources.inject(instance);
            }
        });
    }

    public Atom build() {
        Object value2;
        Object obj;
        long start = System.currentTimeMillis();
        if (this.configuration != null) {
            for (Configurable configurable : this.configurables) {
                this.configuration.configure(configurable.instance, configurable.prefix, this::get, (value, toType, instance) -> {
                    Package p;
                    if (instance != null && ((p = instance.getClass().getPackage()) == null || !p.getName().startsWith("java.") && !p.getName().startsWith("javax."))) {
                        this.resources.inject(instance);
                    }
                });
            }
        }
        this.configurables.clear();
        this.resources.onOpen();
        this.boundInstances.values().forEach(this.resources::inject);
        if (this.get(PRE_INIT) != null) {
            obj = this.get(PRE_INIT);
            this.resourceManager.runNow((Object)this, obj);
        }
        for (String key : this.boundInstances.keySet()) {
            Object value3 = this.boundInstances.get(key);
            if (this.beanLifecycle.isBeanInitialized(value3)) continue;
            if (value3 instanceof Initializable) {
                ((Initializable)value3).initialize(this.resources);
            }
            if (this.resourceManager.getScripting().isRunnable(value3)) continue;
            this.beanLifecycle.fireBeanInitialized(key, value3);
        }
        if (this.get(POST_INIT) != null) {
            obj = this.get(POST_INIT);
            this.resourceManager.runNow((Object)this, obj);
        }
        if (this.boundInstances.size() > 0) {
            RunStartable runStartable = new RunStartable();
            runStartable.name = this.getName();
            for (String key : this.boundInstances.keySet()) {
                value2 = this.boundInstances.get(key);
                if (!(value2 instanceof Startable)) continue;
                runStartable.add(key, (Startable)value2);
            }
            if (runStartable.startables.size() > 0) {
                this.resourceManager.runAfter(runStartable);
            }
        }
        if (this.boundInstances.size() > 0) {
            RunLaunched runLaunched = new RunLaunched(this.resourceManager.getInstance(Provision.class));
            runLaunched.name = this.getName();
            for (String key : this.boundInstances.keySet()) {
                value2 = this.boundInstances.get(key);
                if (!(value2 instanceof LaunchListener)) continue;
                runLaunched.add(key, (LaunchListener)value2);
            }
            if (runLaunched.listeners.size() > 0) {
                this.resourceManager.runLaunched(runLaunched);
            }
        }
        this.resourceManager.runAfterIfNotLoading();
        logger.info("Atom " + this.getName() + " loaded in " + (System.currentTimeMillis() - start) + "ms");
        return this;
    }

    public void discard() {
        this.resources.discard();
        this.configuration = null;
        this.configurables = null;
        this.boundInstances = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Atom open(Consumer<Resources> consumer) {
        Resources resources = null;
        try {
            resources = (Resources)this.resourceManager.open(null);
            consumer.accept(resources);
        }
        finally {
            if (resources != null) {
                try {
                    resources.commit();
                }
                catch (Throwable throwable) {}
            }
        }
        return this;
    }

    public <T> T getInstance(Class<T> cl) {
        return this.resources.getInstance(cl);
    }

    public void runAfter(Object callable) {
        this.resourceManager.runAfter(callable);
    }

    public void run(Object callable) {
        this.resourceManager.runNow((Object)this, callable);
    }

    public void runLaunched(Object callable) {
        this.resourceManager.getScripting().runLaunched(callable);
    }

    @Override
    public int size() {
        return this.resourceManager.getBeans().size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.resourceManager.getBeans().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.resourceManager.getBeans().containsValue(value);
    }

    public void waitFor(String beanName, final Consumer consumer) {
        this.beanLifecycle.addBeanListener(beanName, new BeanListener(){

            @Override
            public void initialized(Object bean) {
                consumer.accept(bean);
                Atom.this.beanLifecycle.removeBeanListener(this);
            }
        });
    }

    public void waitFor(Class cls, final Consumer consumer) {
        this.beanLifecycle.addBeanListener(cls, new BeanListener(){

            @Override
            public void initialized(Object bean) {
                consumer.accept(bean);
                Atom.this.beanLifecycle.removeBeanListener(this);
            }
        });
    }

    public void configuration(Object c) {
        this.put(CONFIGURATION, c);
    }

    public void preInit(Closure c) {
        this.put(PRE_INIT, (Object)c);
    }

    public void postInit(Closure c) {
        this.put(POST_INIT, (Object)c);
    }

    public void after(Closure c) {
        this.put(AFTER, (Object)c);
    }

    public void launched(Closure c) {
        this.put(LAUNCHED, (Object)c);
    }

    public Object exec(String str) {
        return this.put(EXEC, (Object)str);
    }

    public void exec(List list) {
        this.put(EXEC, (Object)list);
    }

    private boolean isDirective(String key) {
        return this.directives.containsKey(key);
    }

    private Object processDirective(String key, Object value) {
        if (EXEC.equals(key) && value instanceof String) {
            return this.resourceManager.exec(value.toString());
        }
        this.directives.get(key).accept(key, value);
        return null;
    }

    @Override
    public Object get(Object key) {
        if (key instanceof String && ((String)key).contains(".")) {
            String[] path = ((String)key).split("\\.");
            Object obj = this.get(path[0].trim());
            for (int i = 1; i < path.length; ++i) {
                obj = Reflection.getProperty(obj, path[i].trim());
            }
            return obj;
        }
        if (NAME.equals(key)) {
            return this.name;
        }
        if (RESOURCES.equals(key)) {
            return this.resources;
        }
        if (RESOURCE_MANAGER.equals(key)) {
            return this.resourceManager;
        }
        if (WAIT_FOR.equals(key)) {
            return new MyBeanListener();
        }
        if (CONFIGURATION.equals(key)) {
            return this.configuration;
        }
        Object object = this.boundInstances.get(key);
        if (object == null) {
            if (key instanceof Class) {
                try {
                    object = this.resources.getInstance((Class)key);
                }
                catch (InstanceNotFoundException ex) {
                    object = this.resourceManager.getBean((Class)key);
                }
            } else {
                object = this.resourceManager.getBean(key.toString());
            }
        }
        if (object == null) {
            object = this.resourceManager.getScripting().get(key.toString());
        }
        return object;
    }

    private void registerBean(String key, Object value) {
        if (!key.startsWith("_")) {
            Object existing = this.resourceManager.getBean(key);
            if (existing == null) {
                this.resourceManager.addBean(key, value);
                this.resources.onOpen();
                this.resources.inject(value);
            } else if (existing != value) {
                throw logger.runtimeException("bean with name=" + this.name + " already registered");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object put(String key, Object value) {
        instance = null;
        duplicate = false;
        try {
            if (value == null) {
                throw new IllegalArgumentException("value for key=" + key + " is null!  This happens because you did not import the class.");
            }
            if (value instanceof Class) {
                if (this.boundInstances.containsKey(key)) {
                    instance = this.boundInstances.get(key);
                    cls = (Class)value;
                    if (!instance.getClass().isAssignableFrom(cls)) {
                        throw new IllegalArgumentException("Incompatible instance found for key=" + key + ", the existing instance has type=" + instance.getClass().getName() + " but requested type=" + cls.getName());
                    }
                    duplicate = true;
                } else if (ResourceProvider.class.isAssignableFrom((Class)value)) {
                    cls = (Class)value;
                    try {
                        if (this.resourceManager.getBean(cls) != null && !key.startsWith("_")) {
                            instance = this.resourceManager.getBean(cls);
                        }
                        instance = cls.newInstance();
                        this.resourceManager.addResourceProvider((ResourceProvider)instance);
                        if (key.startsWith("_")) ** GOTO lbl39
                        this.resourceManager.addBean(key, instance);
                    }
                    catch (Exception e) {
                        throw Atom.logger.runtimeException(e);
                    }
                } else {
                    cls = (Class)value;
                    try {
                        instance = this.resourceManager.getBean(cls) != null && !key.startsWith("_") ? this.resourceManager.getBean(cls) : cls.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw Atom.logger.runtimeException(e);
                    }
                    this.registerBean(key, instance);
                    if (instance == null) {
                        throw new RuntimeException("Cannot instantiate " + value);
                    }
                    this.resources.rebind(cls, instance);
                }
lbl39:
                // 5 sources

                this.configure(instance, key);
            } else if (value instanceof ResourceProvider) {
                if (!key.startsWith("_")) {
                    this.resourceManager.addBean(key, value);
                }
                this.resourceManager.addResourceProvider((ResourceProvider)value);
                instance = value;
                this.configure(instance, key);
            } else if (value instanceof Configuration) {
                instance = value;
                this.resources.configurator.putAll((Configuration)value);
                this.configuration = (Configuration)value;
            } else {
                if (this.isDirective(key)) {
                    return this.processDirective(key, value);
                }
                if ("resources".equals(key)) {
                    throw new IllegalArgumentException("Cannot set resources");
                }
                if ("resourceManager".equals(key)) {
                    throw new IllegalArgumentException("Cannot set resourceManager");
                }
                if (this.resourceManager.getScripting().isRunnable(value)) {
                    if (this.boundInstances.get(key) != null) {
                        instance = this.boundInstances.get(key);
                        this.resourceManager.runNow(instance, value);
                    } else {
                        instance = value;
                    }
                } else if (!this.resourceManager.getScripting().isRunnable(value)) {
                    instance = this.resources.rebind(value.getClass(), value);
                    this.registerBean(key, instance);
                    this.configure(instance, key);
                } else {
                    instance = value;
                }
            }
            if (!duplicate) {
                if (instance != null && !this.resourceManager.getScripting().isRunnable(instance) && this.resourceManager.getScripting().isRunnable(this.boundInstances.get(key))) {
                    closure = this.boundInstances.get(key);
                    this.resourceManager.runNow(instance, closure);
                }
                if (instance != null) {
                    if (instance instanceof ClassBeanListener) {
                        l = (ClassBeanListener)instance;
                        for (Class cl : l.listenFor()) {
                            this.beanLifecycle.addBeanListener(cl, l);
                        }
                    }
                    if (instance instanceof NamedBeanListener) {
                        l = (NamedBeanListener)instance;
                        for (String beanName : l.listenFor()) {
                            this.beanLifecycle.addBeanListener(beanName, l);
                        }
                    }
                    this.boundInstances.put(key, instance);
                }
            }
        }
        catch (NestedScriptException th) {
            throw th;
        }
        catch (Throwable th) {
            Atom.logger.error("Component name=" + this.getName() + " has issues", th);
            throw new RuntimeException(th);
        }
        return instance;
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (String string : m.keySet()) {
            this.put(string, m.get(string));
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        return this.boundInstances.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.boundInstances.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.boundInstances.entrySet();
    }

    class MyBeanListener
    extends GroovyObjectSupport {
        MyBeanListener() {
        }

        public Object invokeMethod(String name, Object args) {
            Object[] arguments = (Object[])args;
            final Closure closure = (Closure)arguments[0];
            Atom.this.beanLifecycle.addBeanListener(name, new BeanListener(){

                @Override
                public void initialized(Object bean) {
                    closure.call(bean);
                    Atom.this.beanLifecycle.removeBeanListener(this);
                }
            });
            return null;
        }
    }

    private static class NestedScriptException
    extends RuntimeException {
        public NestedScriptException() {
        }

        public NestedScriptException(String message) {
            super(message);
        }

        public NestedScriptException(String message, Throwable cause) {
            super(message, cause);
        }

        public NestedScriptException(Throwable cause) {
            super(cause);
        }
    }

    class Configurable {
        Object instance;
        String prefix;

        Configurable(Object instance, String prefix) {
            this.instance = instance;
            this.prefix = prefix;
        }
    }

    class RunLaunched
    implements Runnable {
        Map<String, LaunchListener> listeners = new LinkedHashMap<String, LaunchListener>();
        String name;
        Provision provision;

        RunLaunched(Provision provision) {
            this.provision = provision;
        }

        void add(String key, LaunchListener listener) {
            this.listeners.put(key, listener);
        }

        @Override
        public void run() {
            try {
                for (String key : this.listeners.keySet()) {
                    LaunchListener listener = this.listeners.get(key);
                    if (Atom.this.beanLifecycle.isBeanLaunched(listener)) continue;
                    listener.launched(this.provision);
                    Atom.this.beanLifecycle.fireBeanLaunched(key, listener);
                }
            }
            catch (RuntimeException ex) {
                logger.error("Error running launched component name = " + this.name);
                throw ex;
            }
        }
    }

    class RunStartable
    implements Runnable {
        Map<String, Startable> startables = new LinkedHashMap<String, Startable>();
        String name;

        RunStartable() {
        }

        void add(String key, Startable listener) {
            this.startables.put(key, listener);
        }

        @Override
        public void run() {
            try {
                for (String key : this.startables.keySet()) {
                    Startable startable = this.startables.get(key);
                    if (Atom.this.beanLifecycle.isBeanStarted(startable)) continue;
                    long s = System.currentTimeMillis();
                    startable.start();
                    logger.info("Class " + startable.getClass() + " started in " + (System.currentTimeMillis() - s));
                    Atom.this.beanLifecycle.fireBeanStarted(key, startable);
                }
            }
            catch (RuntimeException ex) {
                logger.error("Error running startable component name = " + this.name);
                throw ex;
            }
        }
    }
}

