/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import net.e6tech.elements.common.reflection.Primitives;

public class Annotator
implements InvocationHandler {
    private Map<Method, Object> values;
    private Method lastAccessed;
    private Class<? extends Annotation> type;
    private Integer hashCode;
    private String toString;

    public static <T extends Annotation> T create(Class<? extends Annotation> cls, BiConsumer<AnnotationValue, T> consumer) {
        LinkedHashMap<Method, Object> values = new LinkedHashMap<Method, Object>();
        for (Method method : cls.getDeclaredMethods()) {
            if (method.getName().equals("hashCode") && method.getParameterCount() == 0 || method.getName().equals("equals") && method.getParameterCount() == 1 || method.getName().equals("annotationType") && method.getParameterCount() == 0 || method.getName().equals("toString") && method.getParameterCount() == 0) continue;
            Object defaultValue = method.getDefaultValue();
            values.put(method, defaultValue);
        }
        Annotator annotator = new Annotator(cls, values);
        AnnotationValue annotationValue = new AnnotationValue(annotator);
        if (consumer != null) {
            consumer.accept(annotationValue, (AnnotationValue)((Object)((Annotation)Proxy.newProxyInstance(cls.getClassLoader(), new Class[]{cls}, (InvocationHandler)annotator))));
        }
        return (T)((Annotation)Proxy.newProxyInstance(cls.getClassLoader(), new Class[]{cls}, (InvocationHandler)new Annotator(cls, values)));
    }

    protected Annotator(Class type, Map<Method, Object> values) {
        this.type = type;
        this.values = values;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("hashCode") && method.getParameterCount() == 0) {
            if (this.hashCode == null) {
                this.hashCode = this.hashCodeImpl();
            }
            return this.hashCode;
        }
        if (method.getName().equals("equals") && method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(Object.class)) {
            return this.equalsImpl(args[0]);
        }
        if (method.getName().equals("annotationType") && method.getParameterCount() == 0) {
            return this.type;
        }
        if (method.getName().equals("toString") && method.getParameterCount() == 0) {
            if (this.toString == null) {
                this.toString = this.toStringImpl();
            }
            return this.toString;
        }
        this.lastAccessed = method;
        Object value = this.values.get(method);
        if (value == null && method.getReturnType().isPrimitive()) {
            return Primitives.defaultValue(method.getReturnType());
        }
        return value;
    }

    private int hashCodeImpl() {
        int hash = 0;
        for (Map.Entry<Method, Object> entry : this.values.entrySet()) {
            hash += 127 * entry.getKey().getName().hashCode() ^ Primitives.hashCode(entry.getValue());
        }
        return hash;
    }

    private boolean equalsImpl(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!this.type.isInstance(object)) {
            return false;
        }
        for (Map.Entry<Method, Object> entry : this.values.entrySet()) {
            Method method = entry.getKey();
            Object value1 = entry.getValue();
            try {
                Object value2 = method.invoke(object, new Object[0]);
                if (Primitives.equals(value1, value2)) continue;
                return false;
            }
            catch (Throwable e) {
                return false;
            }
        }
        return true;
    }

    private String toStringImpl() {
        StringBuilder builder = new StringBuilder(128);
        builder.append('@');
        builder.append(this.type.getName());
        builder.append('(');
        boolean first = true;
        for (Map.Entry<Method, Object> entry : this.values.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(entry.getKey().getName());
            builder.append('=');
            builder.append(Primitives.toString(entry.getValue()));
        }
        builder.append(')');
        return builder.toString();
    }

    public static class AnnotationValue {
        private Annotator handler;

        public AnnotationValue(Annotator handler) {
            this.handler = handler;
        }

        public AnnotationValue set(Callable<String> callable, String value) {
            return this._set(callable, value);
        }

        public AnnotationValue set(Callable<Boolean> callable, Boolean value) {
            return this._set(callable, value);
        }

        public AnnotationValue set(Callable<boolean[]> callable, boolean[] value) {
            return this._set(callable, value);
        }

        public AnnotationValue set(Callable<Byte> callable, Byte value) {
            return this._set(callable, value);
        }

        public AnnotationValue set(Callable<byte[]> callable, byte[] value) {
            return this._set(callable, value);
        }

        public AnnotationValue set(Callable<Character> callable, Character value) {
            return this._set(callable, value);
        }

        public AnnotationValue set(Callable<char[]> callable, char[] value) {
            return this._set(callable, value);
        }

        public AnnotationValue set(Callable<Double> callable, Double value) {
            return this._set(callable, value);
        }

        public AnnotationValue set(Callable<double[]> callable, double[] value) {
            return this._set(callable, value);
        }

        public AnnotationValue set(Callable<Float> callable, Float value) {
            return this._set(callable, value);
        }

        public AnnotationValue set(Callable<float[]> callable, float[] value) {
            return this._set(callable, value);
        }

        public AnnotationValue set(Callable<Integer> callable, Integer value) {
            return this._set(callable, value);
        }

        public AnnotationValue set(Callable<int[]> callable, int[] value) {
            return this._set(callable, value);
        }

        public AnnotationValue set(Callable<Long> callable, Long value) {
            return this._set(callable, value);
        }

        public AnnotationValue set(Callable<long[]> callable, long[] value) {
            return this._set(callable, value);
        }

        public AnnotationValue set(Callable<Short> callable, Short value) {
            return this._set(callable, value);
        }

        public AnnotationValue set(Callable<short[]> callable, short[] value) {
            return this._set(callable, value);
        }

        private <K> AnnotationValue _set(Callable<K> callable, K value) {
            try {
                callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.handler.values.put(this.handler.lastAccessed, value);
            this.handler.hashCode = null;
            this.handler.toString = null;
            this.handler.lastAccessed = null;
            return this;
        }
    }
}

