/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import net.e6tech.elements.common.resources.Merge;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.UnitOfWork;

public class ResourcesFactory {
    @Inject
    Provision provision;
    List<Consumer<Resources>> configurations = new LinkedList<Consumer<Resources>>();

    public void addConfiguration(String configName, Object object) {
        this.add(resources -> resources.addConfiguration(configName, object));
    }

    public UnitOfWork open() {
        return this.provision.preOpen(resources -> {
            if (this.configurations != null) {
                for (Consumer<Resources> c : this.configurations) {
                    c.accept((Resources)resources);
                }
            }
        });
    }

    private Consumer<Resources> config() {
        return resources -> {
            for (Consumer<Resources> c : this.configurations) {
                c.accept((Resources)resources);
            }
        };
    }

    public void add(Consumer<Resources> consumer) {
        this.configurations.add(consumer);
    }

    public Provision getProvision() {
        return this.provision;
    }

    @Merge
    public ResourcesFactory merge(ResourcesFactory instance) {
        this.configurations.addAll(instance.configurations);
        return this;
    }
}

