/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import net.e6tech.elements.common.resources.OnOpen;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.resources.ResourceProvider;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.Transactional;

public class UnitOfWork
implements Transactional {
    ResourceManager resourceManager;
    List<ResourceProvider> resourceProviders = new LinkedList<ResourceProvider>();
    Consumer<Resources> preOpen;
    Resources resources;
    List<Transactional.ConsumerWithException<? extends Resources>> unitOfWork = new LinkedList<Transactional.ConsumerWithException<? extends Resources>>();

    public UnitOfWork(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public UnitOfWork preOpen(Consumer<Resources> consumer) {
        this.preOpen = consumer;
        return this;
    }

    public UnitOfWork onOpen(OnOpen onOpen) {
        this.resourceProviders.add(onOpen);
        return this;
    }

    public Resources getResources() {
        return this.resources;
    }

    @Override
    public <Res extends Resources> Res open() {
        return this.open(null);
    }

    @Override
    public <Res extends Resources> Res open(Map<Class<? extends Annotation>, Annotation> annotations) {
        if (this.resources != null && this.resources.isOpened()) {
            return (Res)this.resources;
        }
        this.resources = this.resourceManager.open(annotations, r -> {
            if (this.preOpen != null) {
                this.preOpen.accept((Resources)r);
            }
            for (ResourceProvider p : this.resourceProviders) {
                r.addResourceProvider(p);
            }
        });
        return (Res)this.resources;
    }

    public void commit() {
        if (this.resources == null || !this.resources.isOpened()) {
            throw new IllegalStateException("Resources not opened");
        }
        this.resources.commit();
        this.resources = null;
    }

    public void abort() {
        if (this.resources == null || this.resources.isAborted() || this.resources.isClosed()) {
            return;
        }
        this.resources.abort();
    }

    public void submit(Transactional.RunnableWithException work) {
        if (this.resources == null || !this.resources.isOpened()) {
            throw new IllegalStateException("Resources not opened");
        }
        this.resources.submit((Res res) -> work.run());
    }

    public <Res extends Resources> void submit(Transactional.ConsumerWithException<Res> work) {
        if (this.resources == null || !this.resources.isOpened()) {
            throw new IllegalStateException("Resources not opened");
        }
        this.resources.submit(work);
    }

    public <R> R submit(Callable<R> work) {
        if (this.resources == null || !this.resources.isOpened()) {
            throw new IllegalStateException("Resources not opened");
        }
        return (R)this.resources.submit((Res res) -> work.call());
    }

    public <Res extends Resources, R> R submit(Transactional.FunctionWithException<Res, R> work) {
        if (this.resources == null || !this.resources.isOpened()) {
            throw new IllegalStateException("Resources not opened");
        }
        return this.resources.submit(work);
    }

    public boolean isOpened() {
        if (this.resources == null) {
            return false;
        }
        return this.resources.isOpened();
    }

    public boolean isAborted() {
        if (this.resources == null) {
            return false;
        }
        return this.resources.isAborted();
    }
}

