/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.notification;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.e6tech.elements.common.notification.Notification;
import net.e6tech.elements.common.notification.NotificationListener;
import net.e6tech.elements.common.subscribe.Broadcast;
import net.e6tech.elements.common.subscribe.Subscriber;

public class NotificationCenter
implements Broadcast {
    private Map<Object, List<NotificationListener>> srcNotificationListeners = new Hashtable<Object, List<NotificationListener>>();
    private Map<Class, List<NotificationListener>> notificationListeners = new Hashtable<Class, List<NotificationListener>>();
    Map<Object, List<Subscriber>> subscribers = new Hashtable<Object, List<Subscriber>>();
    List<Broadcast> broadcasts = new Vector<Broadcast>();

    public void addSourceNotificationListener(Object src, NotificationListener listener) {
        List listeners = this.srcNotificationListeners.computeIfAbsent(src, n -> new Vector());
        listeners.add(listener);
    }

    public void removeSourceNotificationListener(Object src, NotificationListener listener) {
        List listeners = this.srcNotificationListeners.computeIfAbsent(src, n -> new Vector());
        listeners.remove(listener);
    }

    public <T extends Notification> void addNotificationListener(Class<T> cls, NotificationListener<T> listener) {
        List listeners = this.notificationListeners.computeIfAbsent(cls, n -> new Vector());
        listeners.add(listener);
    }

    public <T extends Notification> void removeNotificationListener(Class<T> cls, NotificationListener<T> listener) {
        List listeners = this.notificationListeners.computeIfAbsent(cls, n -> new Vector());
        listeners.remove(listener);
    }

    public void fireNotification(Notification notification) {
        List<NotificationListener> listeners;
        if (notification.source() != null && (listeners = this.srcNotificationListeners.get(notification.source())) != null) {
            listeners.forEach(listener -> listener.onEvent(notification));
        }
        if ((listeners = this.notificationListeners.get(notification.getClass())) != null) {
            listeners.forEach(listener -> listener.onEvent(notification));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(String topic, Subscriber subscriber) {
        List list = this.subscribers.computeIfAbsent(topic, key -> new LinkedList());
        List list2 = list;
        synchronized (list2) {
            list.add(subscriber);
        }
        for (Broadcast broadcast : this.broadcasts) {
            broadcast.subscribe(topic, subscriber);
        }
    }

    @Override
    public <T extends Serializable> void subscribe(Class<T> topic, Subscriber<T> listener) {
        this.subscribe(topic.getName(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(String topic, Subscriber subscriber) {
        List list = this.subscribers.computeIfAbsent(topic, key -> new LinkedList());
        List list2 = list;
        synchronized (list2) {
            list.remove(subscriber);
        }
        for (Broadcast broadcast : this.broadcasts) {
            broadcast.unsubscribe(topic, subscriber);
        }
    }

    @Override
    public void unsubscribe(Class topic, Subscriber subscriber) {
        this.unsubscribe(topic.getName(), subscriber);
    }

    @Override
    public void publish(String topic, Serializable object) {
        for (Broadcast broadcast : this.broadcasts) {
            broadcast.publish(topic, object);
        }
    }

    @Override
    public <T extends Serializable> void publish(Class<T> cls, T object) {
        for (Broadcast broadcast : this.broadcasts) {
            broadcast.publish(cls, object);
        }
    }

    public void addBroadcast(Broadcast broadcast) {
        this.broadcasts.add(broadcast);
        for (Map.Entry<Object, List<Subscriber>> entry : this.subscribers.entrySet()) {
            for (Subscriber subscriber : entry.getValue()) {
                if (entry.getKey() instanceof String) {
                    broadcast.subscribe((String)entry.getKey(), subscriber);
                    continue;
                }
                if (!(entry.getKey() instanceof Class)) continue;
                broadcast.subscribe((Class)entry.getKey(), subscriber);
            }
        }
    }

    public void removeBroadcast(Broadcast broadcast) {
        this.broadcasts.remove(broadcast);
        for (Map.Entry<Object, List<Subscriber>> entry : this.subscribers.entrySet()) {
            for (Subscriber subscriber : entry.getValue()) {
                if (entry.getKey() instanceof String) {
                    broadcast.unsubscribe((String)entry.getKey(), subscriber);
                    continue;
                }
                if (!(entry.getKey() instanceof Class)) continue;
                broadcast.unsubscribe((Class)entry.getKey(), subscriber);
            }
        }
    }
}

