/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.notification;

import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import net.e6tech.elements.common.notification.Notification;
import net.e6tech.elements.common.notification.NotificationCenter;
import net.e6tech.elements.common.notification.NotificationListener;
import net.e6tech.elements.common.resources.Provision;

public class NotificationProcessor
implements NotificationListener {
    @Inject(optional=true)
    protected ExecutorService threadPool;
    @Inject
    protected NotificationCenter notificationCenter;
    @Inject
    protected Provision provision;
    private Map<Class<? extends Notification>, Method> methods = new HashMap<Class<? extends Notification>, Method>();
    private Class<? extends Notification>[] notificationTypes = new Class[0];

    public NotificationProcessor() {
        Class<?> cls = this.getClass();
        ArrayList types = new ArrayList();
        while (cls != null & !cls.equals(Object.class)) {
            Method[] methods;
            for (Method method : methods = cls.getDeclaredMethods()) {
                if (!method.getName().equals("processEvent") || method.getParameterCount() != 1 || !Notification.class.isAssignableFrom(method.getParameterTypes()[0])) continue;
                method.setAccessible(true);
                Class<?> notificationType = method.getParameterTypes()[0];
                this.methods.computeIfAbsent(notificationType, key -> method);
                types.add(notificationType);
            }
            cls = cls.getSuperclass();
        }
        this.notificationTypes = types.toArray(new Class[types.size()]);
    }

    @Override
    public Class<? extends Notification>[] getNotificationTypes() {
        return this.notificationTypes;
    }

    public void onEvent(Notification notification) {
        Class<?> cls = notification.getClass();
        while (!cls.equals(Object.class)) {
            Method method = this.methods.get(notification.getClass());
            if (method != null) {
                try {
                    method.invoke((Object)this, notification);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            cls = cls.getSuperclass();
        }
        this.catchEvent(notification);
    }

    public void catchEvent(Notification notification) {
    }

    public void run(Runnable runnable) {
        this.threadPool.execute(runnable);
    }
}

