/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

public abstract class Retry {
    private int limit = 3;

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public abstract boolean shouldRetry(Throwable var1);

    public <R> R retry(Retryable<R> call) throws Throwable {
        return this._retry(null, call);
    }

    public <R> R retry(Throwable exception, Retryable<R> call) throws Throwable {
        return this._retry(exception, call);
    }

    protected <R> R _retry(Throwable exception, Retryable<R> call) throws Throwable {
        R ret = null;
        Throwable error = exception;
        boolean success = false;
        int count = 0;
        while ((error == null || this.shouldRetry(error)) && count < this.limit) {
            if (error != null) {
                ++count;
            }
            try {
                ret = call.call();
                success = true;
                break;
            }
            catch (Throwable th) {
                error = exception;
            }
        }
        if (!success) {
            throw error;
        }
        return ret;
    }

    public static interface Retryable<R> {
        public R call() throws Throwable;
    }
}

