/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.reflection;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;
import net.e6tech.elements.common.cache.CacheFacade;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.reflection.CopyListener;
import net.e6tech.elements.common.reflection.DoNotCopy;
import net.e6tech.elements.common.util.TextSubstitution;
import net.e6tech.elements.common.util.lambda.Each;

public class Reflection {
    private static final PrivateSecurityManager securityManager = new PrivateSecurityManager();
    private static CacheFacade<Class, Type[]> parametrizedTypes = new CacheFacade<Class, Type[]>("parameterizedTypes"){};
    static Logger logger = Logger.getLogger();

    public static PropertyDescriptor propertyDescriptor(Method method) {
        String property;
        String name = method.getName();
        Parameter[] parameters = method.getParameters();
        if (name.startsWith("set")) {
            if (parameters.length != 1) {
                throw new IllegalArgumentException("" + method.getName() + " is not a setter");
            }
            property = name.substring(3);
        } else if (name.startsWith("get")) {
            if (parameters.length != 0) {
                throw new IllegalArgumentException("" + method.getName() + " is not a getter");
            }
            property = name.substring(3);
        } else if (name.startsWith("is")) {
            if (parameters.length != 0) {
                throw new IllegalArgumentException("" + method.getName() + " is not a getter");
            }
            property = name.substring(2);
        } else {
            throw new IllegalArgumentException("" + method.getName() + " is not an property accessor");
        }
        boolean lowerCase = true;
        if (property.length() > 1 && Character.isUpperCase(property.charAt(1))) {
            lowerCase = false;
        }
        if (lowerCase) {
            property = property.substring(0, 1).toLowerCase(Locale.ENGLISH) + property.substring(1);
        }
        try {
            return new PropertyDescriptor(property, method.getDeclaringClass());
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class getCallingClass() {
        int i;
        Class<?>[] trace = securityManager.getClassContext();
        String thisClassName = Reflection.class.getName();
        for (i = 0; i < trace.length && !thisClassName.equals(trace[i].getName()); ++i) {
        }
        if (i >= trace.length || i + 2 >= trace.length) {
            throw new IllegalStateException("Failed to find caller in the stack");
        }
        return trace[i + 2];
    }

    public static <V, C> Optional<V> mapCallingStackTrace(Function<Each<StackTraceElement, C>, ? extends V> mapper) {
        Throwable th = new Throwable();
        StackTraceElement[] trace = th.getStackTrace();
        String thisClassName = Reflection.class.getName();
        for (int i = 0; i < trace.length && !thisClassName.equals(trace[i].getClassName()); ++i) {
        }
        Each.Mutator mutator = Each.create();
        for (int j = i + 2; j < trace.length; ++j) {
            mutator.setValue(trace[j]);
            V v = mapper.apply(mutator.each());
            if (v == null) continue;
            return Optional.of(v);
        }
        return Optional.empty();
    }

    public static void printStackTrace(StringBuilder builder, String indent, int start, int end) {
        StackTraceElement[] elements = new Throwable().getStackTrace();
        for (int i = start + 1; i < end && i < elements.length; ++i) {
            builder.append("\n");
            if (indent != null) {
                builder.append(indent);
            }
            builder.append(elements[i].getClassName());
            builder.append(".");
            builder.append(elements[i].getMethodName());
            builder.append("(");
            builder.append(elements[i].getFileName());
            builder.append(":");
            builder.append(elements[i].getLineNumber());
            builder.append(")");
        }
    }

    public static <T> T newInstance(String className, ClassLoader loader) {
        try {
            return Reflection.loadClass(className, loader).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class loadClass(String className, ClassLoader loader) {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null) {
            loader = Reflection.getCallingClass().getClassLoader();
        }
        try {
            return loader.loadClass(className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void forEachAnnotatedAccessor(Class objectClass, Class<? extends Annotation> annotationClass, Consumer<AccessibleObject> consumer) {
        PropertyDescriptor[] props;
        Class cls = objectClass;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(cls);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        for (PropertyDescriptor prop : props = beanInfo.getPropertyDescriptors()) {
            if (prop.getReadMethod() == null || prop.getReadMethod().getAnnotation(annotationClass) == null) continue;
            consumer.accept(prop.getReadMethod());
        }
        while (!cls.equals(Object.class)) {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                if (field.getAnnotation(annotationClass) == null) continue;
                consumer.accept(field);
            }
            cls = cls.getSuperclass();
        }
    }

    public static <V> V getProperty(Object object, String property) {
        try {
            Class<?> cls = null;
            cls = object instanceof Class ? (Class<?>)object : object.getClass();
            PropertyDescriptor desc = new PropertyDescriptor(property, object.getClass(), "is" + TextSubstitution.capitalize(property), null);
            if (desc == null || desc.getReadMethod() == null) {
                return null;
            }
            return (V)desc.getReadMethod().invoke(object, new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException(object.getClass().getName() + "." + property, e);
        }
    }

    public static <V> V getField(Object object, String fieldName) {
        Field field = Reflection.getField(object.getClass(), fieldName);
        try {
            return (V)field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void setField(Object object, String fieldName, Object value) {
        Field field = Reflection.getField(object.getClass(), fieldName);
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Field getField(Class cls, String fieldName) {
        while (cls != null || !cls.equals(Object.class)) {
            try {
                Field field = cls.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (Throwable field) {
                try {
                    cls = cls.getSuperclass();
                }
                catch (Throwable e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        throw new IllegalStateException("No bankId defined");
    }

    public static Class getParametrizedType(Class clazz, int index) {
        Type[] pTypes = parametrizedTypes.get(clazz, () -> {
            Class cls = clazz;
            while (!cls.equals(Object.class)) {
                try {
                    Type genericSuper = cls.getGenericSuperclass();
                    if (genericSuper instanceof ParameterizedType) {
                        ParameterizedType parametrizedType = (ParameterizedType)genericSuper;
                        return parametrizedType.getActualTypeArguments();
                    }
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
                cls = cls.getSuperclass();
            }
            return null;
        });
        if (pTypes == null) {
            throw new IllegalArgumentException("No parametrized types found");
        }
        if (pTypes.length <= index) {
            throw new IllegalArgumentException("No parametrized type at index=" + index);
        }
        if (pTypes[index] instanceof Class) {
            return (Class)pTypes[index];
        }
        return null;
    }

    public static <T> List<T> newInstance(Class<T> cls, List objectList) {
        return Reflection.newInstance(cls, objectList, null);
    }

    public static <T> List<T> newInstance(Class<T> cls, List objectList, CopyListener listener) {
        if (objectList == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (Object o : objectList) {
            T target = new Instance().newInstance(cls, o, listener);
            list.add(target);
        }
        return list;
    }

    public static <T> T newInstance(Class<T> cls, Object object) {
        return (T)new Instance().newInstance(cls, object, new HashMap(), null);
    }

    public static <T> T newInstance(Class<T> cls, Object object, CopyListener listener) {
        return (T)new Instance().newInstance(cls, object, new HashMap(), listener);
    }

    public static void copyInstance(Object target, Object object) {
        new Instance().copy(target, object, new HashMap(), null);
    }

    public static void copyInstance(Object target, Object object, CopyListener listener) {
        new Instance().copy(target, object, new HashMap(), listener);
    }

    public static boolean compare(Object target, Object object) {
        return new Instance().compare(target, object);
    }

    public static class Instance {
        Map<Class, Map<String, Method>> setters = new HashMap<Class, Map<String, Method>>();
        Map<Class, PropertyDescriptor[]> propertyDescriptors = new HashMap<Class, PropertyDescriptor[]>();

        private Map<String, Method> getSetters(Class cls) {
            return this.setters.computeIfAbsent(cls, key -> {
                PropertyDescriptor[] props;
                HashMap<String, Method> methods = new HashMap<String, Method>();
                for (PropertyDescriptor prop : props = this.getBeanInfo((Class)key).getPropertyDescriptors()) {
                    if (prop.getWriteMethod() == null) continue;
                    methods.put(prop.getName(), prop.getWriteMethod());
                }
                return methods;
            });
        }

        private PropertyDescriptor[] getPropertyDescriptors(Class cls) {
            return this.propertyDescriptors.computeIfAbsent(cls, key -> this.getBeanInfo((Class)key).getPropertyDescriptors());
        }

        private BeanInfo getBeanInfo(Class cls) {
            try {
                return Introspector.getBeanInfo(cls);
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
        }

        public <T> T newInstance(Class<T> cls, Object object) {
            return new Instance().newInstance(cls, object, new HashMap<Integer, Object>(), null);
        }

        public <T> T newInstance(Class<T> cls, Object object, CopyListener listener) {
            return new Instance().newInstance(cls, object, new HashMap<Integer, Object>(), listener);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private <T> T newInstance(Type toType, Object object, Map<Integer, Object> seen, CopyListener listener) {
            if (object == null) {
                return null;
            }
            Integer hashCode = null;
            if (!object.getClass().isPrimitive() && seen.get(hashCode = Integer.valueOf(System.identityHashCode(object))) != null) {
                return (T)seen.get(hashCode);
            }
            Object target = null;
            if (toType instanceof Class) {
                if (Enum.class.isAssignableFrom((Class)toType)) {
                    target = Enum.valueOf((Class)toType, object.toString());
                } else if (Enum.class.isAssignableFrom(object.getClass()) && String.class.isAssignableFrom((Class)toType)) {
                    target = ((Enum)object).name();
                } else {
                    try {
                        target = ((Class)toType).newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    this.copy(target, object, seen, listener);
                }
            } else {
                ParameterizedType parametrized = (ParameterizedType)toType;
                Class enclosedType = (Class)parametrized.getRawType();
                Type type = parametrized.getActualTypeArguments()[0];
                if (Collection.class.isAssignableFrom(enclosedType)) {
                    AbstractCollection collection = null;
                    collection = List.class.isAssignableFrom(enclosedType) ? new ArrayList() : (Set.class.isAssignableFrom(enclosedType) ? new LinkedHashSet() : new ArrayList());
                    target = collection;
                    if (!(object instanceof Collection)) throw new IllegalStateException("Do not know how to convert " + object.getClass() + " to " + toType);
                    Collection c = (Collection)object;
                    for (Object o : c) {
                        T converted = this.newInstance(type, o, seen, listener);
                        collection.add(converted);
                    }
                } else {
                    try {
                        target = enclosedType.newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    this.copy(target, object, seen, listener);
                }
            }
            if (hashCode == null) return (T)target;
            seen.put(hashCode, target);
            return (T)target;
        }

        public void copy(Object target, Object object, CopyListener copyListener) {
            this.copy(target, object, new HashMap<Integer, Object>(), copyListener);
        }

        public void copy(Object target, Object object) {
            this.copy(target, object, new HashMap<Integer, Object>(), null);
        }

        private void copy(Object target, Object object, Map<Integer, Object> seen, CopyListener copyListener) {
            if (target == null || object == null) {
                return;
            }
            for (PropertyDescriptor prop : this.getPropertyDescriptors(object.getClass())) {
                Method setter;
                if (prop.getReadMethod() == null || (setter = this.getSetters(target.getClass()).get(prop.getName())) == null) continue;
                try {
                    boolean annotated;
                    boolean bl = annotated = prop.getReadMethod().getAnnotation(DoNotCopy.class) != null;
                    if (!annotated && prop.getWriteMethod() != null) {
                        boolean bl2 = annotated = prop.getWriteMethod().getAnnotation(DoNotCopy.class) != null;
                    }
                    if (annotated) continue;
                    try {
                        boolean handled = false;
                        if (copyListener != null) {
                            handled = copyListener.copy(prop.getName(), target, setter, object, prop.getReadMethod());
                        }
                        if (handled) continue;
                        Object value = prop.getReadMethod().invoke(object, new Object[0]);
                        if (setter.getParameterTypes()[0].isAssignableFrom(prop.getReadMethod().getReturnType())) {
                            setter.invoke(target, value);
                            continue;
                        }
                        try {
                            Object converted = this.newInstance(setter.getGenericParameterTypes()[0], value, seen, copyListener);
                            setter.invoke(target, converted);
                        }
                        catch (Throwable ex) {
                            logger.warn("Error copying " + value + " to " + setter.getDeclaringClass() + "::" + setter.getName(), ex);
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public boolean compare(Object target, Object object) {
            Stack<String> stack = new Stack<String>();
            if (target != null) {
                stack.push(target.getClass().getName());
            }
            return this.compare(target, object, new HashSet<String>(), stack);
        }

        private boolean compare(Object target, Object object, Set<String> seen, Stack<String> stack) {
            if (target == null && object == null) {
                return true;
            }
            if (target == null || object == null) {
                return false;
            }
            int hashCode = System.identityHashCode(target);
            int hashCode2 = System.identityHashCode(object);
            String compared = "" + hashCode + ":" + hashCode2;
            if (seen.contains(compared)) {
                return true;
            }
            if (target.getClass().isAssignableFrom(object.getClass())) {
                if (!target.equals(object)) {
                    if (logger.isDebugEnabled()) {
                        StringBuilder builder = new StringBuilder();
                        builder.append("Comparison failed at ");
                        boolean first = true;
                        for (String element : stack) {
                            if (first) {
                                first = false;
                            } else {
                                builder.append(".");
                            }
                            builder.append(element);
                        }
                        logger.debug(builder.toString());
                    }
                    return false;
                }
                return true;
            }
            if (!object.getClass().isPrimitive()) {
                seen.add(compared);
            }
            for (PropertyDescriptor prop : this.getPropertyDescriptors(target.getClass())) {
                if (prop.getReadMethod() == null || prop.getName().equals("class")) continue;
                try {
                    boolean annotated;
                    boolean bl = annotated = prop.getReadMethod().getAnnotation(DoNotCopy.class) != null;
                    if (!annotated && prop.getWriteMethod() != null) {
                        boolean bl2 = annotated = prop.getWriteMethod().getAnnotation(DoNotCopy.class) != null;
                    }
                    if (annotated) continue;
                    Method objectGetter = null;
                    try {
                        PropertyDescriptor objectProp = new PropertyDescriptor(prop.getName(), object.getClass(), "is" + Instance.capitalize(prop.getName()), null);
                        objectGetter = objectProp.getReadMethod();
                    }
                    catch (IntrospectionException objectProp) {
                        // empty catch block
                    }
                    if (objectGetter == null) continue;
                    Object value = objectGetter.invoke(object, new Object[0]);
                    Object targetFieldValue = prop.getReadMethod().invoke(target, new Object[0]);
                    stack.push(prop.getName());
                    if (!this.compare(targetFieldValue, value, seen, stack)) {
                        return false;
                    }
                    stack.pop();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        }

        public static String capitalize(String name) {
            return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
        }
    }

    static final class PrivateSecurityManager
    extends SecurityManager {
        PrivateSecurityManager() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

