/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.reflection;

import java.util.HashMap;
import java.util.Map;

public class Primitives {
    public static Map<String, Class> primitives = new HashMap<String, Class>();

    public static boolean isPrimitive(String name) {
        return primitives.containsKey(name);
    }

    public static boolean isPrimitive(Class cls) {
        return primitives.containsKey(cls.getName());
    }

    public static Class get(String name) {
        return primitives.get(name);
    }

    public static Object defaultValue(Class cls) {
        if (Primitives.isPrimitive(cls)) {
            if (cls == Boolean.TYPE) {
                return false;
            }
            if (cls == Character.TYPE) {
                return Character.valueOf('\u0000');
            }
            if (cls == Byte.TYPE) {
                return (byte)0;
            }
            if (cls == Short.TYPE) {
                return (short)0;
            }
            if (cls == Integer.TYPE) {
                return 0;
            }
            if (cls == Long.TYPE) {
                return 0L;
            }
            if (cls == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (cls == Double.TYPE) {
                return 0.0;
            }
        } else {
            if (cls == Boolean.class) {
                return false;
            }
            if (cls == Character.class) {
                return Character.valueOf('\u0000');
            }
            if (cls == Byte.class) {
                return (byte)0;
            }
            if (cls == Short.class) {
                return (short)0;
            }
            if (cls == Integer.class) {
                return 0;
            }
            if (cls == Long.class) {
                return 0L;
            }
            if (cls == Float.class) {
                return Float.valueOf(0.0f);
            }
            if (cls == Double.class) {
                return 0.0;
            }
        }
        return null;
    }

    static {
        primitives.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primitives.put(Character.TYPE.getName(), Character.TYPE);
        primitives.put(Byte.TYPE.getName(), Byte.TYPE);
        primitives.put(Short.TYPE.getName(), Short.TYPE);
        primitives.put(Integer.TYPE.getName(), Integer.TYPE);
        primitives.put(Long.TYPE.getName(), Long.TYPE);
        primitives.put(Float.TYPE.getName(), Float.TYPE);
        primitives.put(Double.TYPE.getName(), Double.TYPE);
    }
}

