/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.cache;

import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.TouchedExpiryPolicy;
import javax.cache.spi.CachingProvider;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.Resources;

public class CachePool
implements Initializable {
    public static final long defaultExpiry = 900000L;
    protected String provider = "org.ehcache.jsr107.EhcacheCachingProvider";
    protected CacheManager cacheManager;
    protected long expiry = 900000L;
    protected boolean storeByValue = false;

    public long getExpiry() {
        return this.expiry;
    }

    public void setExpiry(long expiry) {
        this.expiry = expiry;
    }

    public boolean isStoreByValue() {
        return this.storeByValue;
    }

    public void setStoreByValue(boolean storeByValue) {
        this.storeByValue = storeByValue;
    }

    @Override
    public void initialize(Resources resources) {
        CachingProvider cachingProvider = Caching.getCachingProvider((String)this.provider);
        this.cacheManager = cachingProvider.getCacheManager();
    }

    public <K, V> Cache<K, V> getCache(String name, Class<K> keyClass, Class<V> valueClass) {
        Cache cache;
        if (this.cacheManager == null) {
            this.initialize(null);
        }
        if ((cache = this.cacheManager.getCache(name, keyClass, valueClass)) != null) {
            return cache;
        }
        MutableConfiguration configuration = new MutableConfiguration();
        configuration.setTypes(keyClass, valueClass);
        configuration.setExpiryPolicyFactory(TouchedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.SECONDS, 10L)));
        configuration.setStoreByValue(this.storeByValue);
        try {
            return this.cacheManager.createCache(name, (Configuration)configuration);
        }
        catch (CacheException ex) {
            return this.cacheManager.getCache(name, keyClass, valueClass);
        }
    }
}

