/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources.plugin;

import java.util.LinkedList;
import java.util.List;

public class Path<T> {
    private Path parent;
    private Class<T> type;
    private String name;

    public static <T> Path<T> of(Class<T> cls, String name) {
        return new Path<T>(cls, name);
    }

    protected Path(Class<T> cls, String name) {
        this.type = cls;
        this.name = name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public <R> Path<R> and(Class<R> cls, String name) {
        Path<R> child = new Path<R>(cls, name);
        child.parent = this;
        return child;
    }

    public <R> Path<R> and(Class<R> cls) {
        Path<R> child = new Path<R>(cls, null);
        child.parent = this;
        return child;
    }

    public List<Path> list() {
        LinkedList<Path> list = new LinkedList<Path>();
        Path path = this;
        while (path != null) {
            list.addFirst(path);
            path = path.parent;
        }
        return list;
    }

    public String path() {
        StringBuilder builder = new StringBuilder();
        List<Path> list = this.list();
        boolean first = true;
        for (Path p : list) {
            if (first) {
                first = false;
            } else {
                builder.append("/");
            }
            builder.append(p.getType().getName());
            if (p.getName() == null) continue;
            builder.append("/").append(p.getName());
        }
        return builder.toString();
    }
}

