/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.serialization;

import java.lang.reflect.Method;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.serialization.ObjectFinder;
import net.e6tech.elements.common.serialization.ObjectReference;

public class DefaultObjectFinder
implements ObjectFinder {
    private static Logger logger = Logger.getLogger();

    @Override
    public Object replaceObject(Object obj) {
        return obj;
    }

    @Override
    public boolean hasObjectReference(Resources resources, Class cls) {
        return this.objectReferenceGet(cls) != null && this.objectReferenceSet(cls) != null;
    }

    @Override
    public ObjectReference toReference(Resources resources, Object object) {
        if (object == null) {
            return null;
        }
        if (this.hasObjectReference(resources, object.getClass())) {
            Method method = this.objectReferenceGet(object.getClass());
            try {
                return (ObjectReference)method.invoke(object, new Object[0]);
            }
            catch (Throwable e) {
                throw logger.runtimeException(e);
            }
        }
        return null;
    }

    @Override
    public Object toObject(Resources resources, ObjectReference ref) {
        if (ref == null) {
            return null;
        }
        try {
            Object obj = resources.newInstance(ref.getTypeClass());
            Method method = this.objectReferenceSet(obj.getClass());
            if (method != null) {
                try {
                    method.invoke(obj, ref);
                }
                catch (Throwable e) {
                    logger.warn(e.getMessage(), e);
                }
            }
            return obj;
        }
        catch (Exception e) {
            throw logger.runtimeException(e);
        }
    }

    protected Method objectReferenceGet(Class cls) {
        try {
            Method method = cls.getMethod("getObjectReference", new Class[0]);
            if (ObjectReference.class.isAssignableFrom(method.getReturnType())) {
                return method;
            }
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return null;
    }

    protected Method objectReferenceSet(Class cls) {
        try {
            return cls.getMethod("setObjectReference", ObjectReference.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

