/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import net.e6tech.elements.common.notification.NotificationCenter;
import net.e6tech.elements.common.resources.ResourceManager;

public interface ResourcePool {
    public ResourceManager getResourceManager();

    default public <T> T getBean(String name) {
        return this.getResourceManager().getBean(name);
    }

    default public <T> T getBean(Class<T> cls) {
        return this.getResourceManager().getBean(cls);
    }

    default public NotificationCenter getNotificationCenter() {
        return this.getResourceManager().getNotificationCenter();
    }

    public <T> T bind(Class<T> var1, T var2);

    public <T> T rebind(Class<T> var1, T var2);

    public <T> T unbind(Class<T> var1);

    public void bindClass(Class var1, Class var2);

    public <T> T bindNamedInstance(String var1, Class<T> var2, T var3);

    public <T> T rebindNamedInstance(String var1, Class<T> var2, T var3);

    public <T> T inject(T var1);

    default public <T> T newInstance(Class<T> cls) {
        try {
            T instance = cls.newInstance();
            this.inject(instance);
            return instance;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

