/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.logging.jul;

import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.e6tech.elements.common.logging.Logger;

public class LoggerAdapter
extends java.util.logging.Logger {
    Logger logger;

    public LoggerAdapter(String name) {
        super(name, null);
        this.logger = Logger.getLogger(name);
    }

    @Override
    public void log(LogRecord record) {
        if (this.isFiltered(record)) {
            return;
        }
        Level level = record.getLevel();
        String message = record.getMessage();
        Object[] parameters = record.getParameters();
        Throwable thrown = record.getThrown();
        this.log(level, message, parameters, thrown);
    }

    boolean isFiltered(LogRecord logRecord) {
        Filter filter = this.getFilter();
        return filter != null && !filter.isLoggable(logRecord);
    }

    public void log(Level level, String message, Object[] parameters, Throwable th) {
        this.log(level, message, th);
    }

    @Override
    public boolean isLoggable(Level level) {
        if (Level.ALL.equals(level)) {
            return true;
        }
        if (Level.CONFIG.equals(level)) {
            this.logger.isInfoEnabled();
        }
        return true;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        throw new UnsupportedOperationException("Cannot set level through log4j-api");
    }

    @Override
    public void log(Level level, String msg) {
        if (Level.ALL.equals(level)) {
            this.logger.info(msg);
        } else if (Level.CONFIG.equals(level)) {
            this.logger.info(msg);
        } else if (Level.FINE.equals(level)) {
            this.logger.debug(msg);
        } else if (Level.FINER.equals(level)) {
            this.logger.debug(msg);
        } else if (Level.FINEST.equals(level)) {
            this.logger.trace(msg);
        } else if (Level.INFO.equals(level)) {
            this.logger.info(msg);
        } else if (Level.SEVERE.equals(level)) {
            this.logger.error(msg);
        } else if (Level.WARNING.equals(level)) {
            this.logger.warn(msg);
        }
    }

    @Override
    public void log(Level level, String msg, Object param1) {
        if (Level.ALL.equals(level)) {
            this.logger.info(msg, param1);
        } else if (Level.CONFIG.equals(level)) {
            this.logger.info(msg, param1);
        } else if (Level.FINE.equals(level)) {
            this.logger.debug(msg, param1);
        } else if (Level.FINER.equals(level)) {
            this.logger.debug(msg, param1);
        } else if (Level.FINEST.equals(level)) {
            this.logger.trace(msg, param1);
        } else if (Level.INFO.equals(level)) {
            this.logger.info(msg, param1);
        } else if (Level.SEVERE.equals(level)) {
            this.logger.error(msg, param1);
        } else if (Level.WARNING.equals(level)) {
            this.logger.warn(msg, param1);
        }
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        if (Level.ALL.equals(level)) {
            this.logger.info(msg, params);
        } else if (Level.CONFIG.equals(level)) {
            this.logger.info(msg, params);
        } else if (Level.FINE.equals(level)) {
            this.logger.debug(msg, params);
        } else if (Level.FINER.equals(level)) {
            this.logger.debug(msg, params);
        } else if (Level.FINEST.equals(level)) {
            this.logger.trace(msg, params);
        } else if (Level.INFO.equals(level)) {
            this.logger.info(msg, params);
        } else if (Level.SEVERE.equals(level)) {
            this.logger.error(msg, params);
        } else if (Level.WARNING.equals(level)) {
            this.logger.warn(msg, params);
        }
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        if (Level.ALL.equals(level)) {
            this.logger.info(msg, thrown);
        } else if (Level.CONFIG.equals(level)) {
            this.logger.info(msg, thrown);
        } else if (Level.FINE.equals(level)) {
            this.logger.debug(msg, thrown);
        } else if (Level.FINER.equals(level)) {
            this.logger.debug(msg, thrown);
        } else if (Level.FINEST.equals(level)) {
            this.logger.trace(msg, thrown);
        } else if (Level.INFO.equals(level)) {
            this.logger.info(msg, thrown);
        } else if (Level.SEVERE.equals(level)) {
            this.logger.error(msg, thrown);
        } else if (Level.WARNING.equals(level)) {
            this.logger.warn(msg, thrown);
        }
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        this.log(level, msg);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        this.log(level, msg, param1);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.log(level, msg, params);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object param1) {
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object[] params) {
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod, Object result) {
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
    }

    @Override
    public void severe(String msg) {
        this.logger.error(msg);
    }

    @Override
    public void warning(String msg) {
        this.logger.warn(msg);
    }

    @Override
    public void info(String msg) {
        this.logger.info(msg);
    }

    @Override
    public void config(String msg) {
        this.logger.info(msg);
    }

    @Override
    public void fine(String msg) {
        this.logger.debug(msg);
    }

    @Override
    public void finer(String msg) {
        this.logger.debug(msg);
    }

    @Override
    public void finest(String msg) {
        this.logger.trace(msg);
    }
}

