/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.launch;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import net.e6tech.elements.common.launch.LaunchController;
import net.e6tech.elements.common.launch.LaunchListener;
import net.e6tech.elements.common.resources.ResourceManager;

class Launcher {
    ResourceManager resourceManager;
    LaunchController controller;
    CountDownLatch latch;
    String provisionDir;

    public Launcher(LaunchController controller) {
        this.controller = controller;
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    public void launch(List<LaunchListener> listeners) {
        String file = this.controller.getLaunchScript();
        if (file == null) {
            throw new IllegalArgumentException("launch file not specified, use launch=<file>");
        }
        Thread thread = new Thread(() -> {
            this.resourceManager = new ResourceManager(this.controller.getProperties());
            this.controller.created(this.resourceManager);
            listeners.forEach(listener -> listener.created(this.resourceManager));
            try {
                this.resourceManager.load(file);
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.exit(1);
            }
            this.latch.countDown();
            ResourceManager resourceManager = this.resourceManager;
            synchronized (resourceManager) {
                try {
                    this.resourceManager.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        thread.setDaemon(false);
        thread.start();
    }

    void onLaunched() {
        this.resourceManager.onLaunched();
    }
}

