/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.reflection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

public class MultiProxy {
    Map<Class, Map<String, InvocationHandler>> handlers = new HashMap<Class, Map<String, InvocationHandler>>();

    public static MultiProxy createProxy(Class cls, InvocationHandler handler, String ... methods) {
        MultiProxy proxy = new MultiProxy();
        return proxy.configure(cls, handler, methods);
    }

    private MultiProxy() {
    }

    public MultiProxy configure(Class cls, InvocationHandler handler, String ... methods) {
        block3: {
            Map methodMap;
            block2: {
                methodMap = this.handlers.computeIfAbsent(cls, key -> new HashMap());
                if (methods == null) break block2;
                for (String method : methods) {
                    methodMap.put(method, handler);
                }
                break block3;
            }
            if (!cls.isInterface()) break block3;
            for (Method method : cls.getMethods()) {
                methodMap.put(method.getName(), handler);
            }
        }
        return this;
    }

    public <T> T createInstance(Object target) {
        Class<?>[] interfaces = target.getClass().getInterfaces();
        boolean found = false;
        for (Class<?> intf : interfaces) {
            if (this.handlers.get(intf) == null) continue;
            found = true;
            break;
        }
        if (!found && this.handlers.get(target.getClass()) == null) {
            throw new IllegalArgumentException("Target class " + target.getClass() + " has no configuration entries");
        }
        MultiInvocationHandler delegateHandler = new MultiInvocationHandler();
        delegateHandler.target = target;
        return (T)Proxy.newProxyInstance(target.getClass().getClassLoader(), interfaces, (InvocationHandler)delegateHandler);
    }

    private class MultiInvocationHandler
    implements InvocationHandler {
        private Object target;

        private MultiInvocationHandler() {
        }

        Object getTarget() {
            return this.target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Map<String, InvocationHandler> methods;
            Object ret = null;
            Class<?>[] interfaces = this.target.getClass().getInterfaces();
            InvocationHandler handler = null;
            for (Class<?> intf : interfaces) {
                Map<String, InvocationHandler> methods2;
                if (intf.getMethod(method.getName(), method.getParameterTypes()) != null && (methods2 = MultiProxy.this.handlers.get(intf)) != null && (handler = methods2.get(method.getName())) != null) break;
            }
            if (handler == null && (methods = MultiProxy.this.handlers.get(this.target.getClass())) != null) {
                handler = methods.get(method.getName());
            }
            if (handler != null) {
                ret = handler.invoke(this.target, method, args);
            } else {
                try {
                    ret = method.invoke(this.target, args);
                }
                catch (InvocationTargetException ex) {
                    throw ex.getCause();
                }
            }
            if (ret != null && (interfaces = ret.getClass().getInterfaces()) != null && interfaces.length > 0) {
                boolean found = false;
                for (Class<?> intf : interfaces) {
                    if (MultiProxy.this.handlers.get(intf) == null) continue;
                    found = true;
                    break;
                }
                if (found) {
                    MultiInvocationHandler delegateHandler = new MultiInvocationHandler();
                    delegateHandler.target = ret;
                    ret = Proxy.newProxyInstance(ret.getClass().getClassLoader(), ret.getClass().getInterfaces(), (InvocationHandler)delegateHandler);
                }
            }
            return ret;
        }
    }
}

