/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.notification;

import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import net.e6tech.elements.common.notification.Notification;
import net.e6tech.elements.common.notification.NotificationCenter;
import net.e6tech.elements.common.notification.NotificationListener;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Startable;

public class NotificationProcessor
implements NotificationListener,
Startable {
    @Inject(optional=true)
    protected ExecutorService threadPool;
    @Inject
    protected NotificationCenter notificationCenter;
    @Inject
    protected Provision provision;
    private Map<Class<? extends Notification>, Method> methods = new HashMap<Class<? extends Notification>, Method>();

    @Override
    public void start() {
        Class<?> cls = this.getClass();
        while (cls != null & !cls.equals(Object.class)) {
            Method[] methods;
            for (Method method : methods = cls.getDeclaredMethods()) {
                if (!method.getName().equals("processEvent") || method.getParameterCount() != 1 || !Notification.class.isAssignableFrom(method.getParameterTypes()[0])) continue;
                method.setAccessible(true);
                this.methods.computeIfAbsent(method.getParameterTypes()[0], key -> method);
            }
            cls = cls.getSuperclass();
        }
        for (Class<? extends Notification> type : this.methods.keySet()) {
            this.notificationCenter.addNotificationListener(type, this);
        }
    }

    public void onEvent(Notification notification) {
        Class<?> cls = notification.getClass();
        while (!cls.equals(Object.class)) {
            Method method = this.methods.get(notification.getClass());
            if (method != null) {
                try {
                    method.invoke((Object)this, notification);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            cls = cls.getSuperclass();
        }
        this.processEvent(notification);
    }

    public void processEvent(Notification notification) {
    }

    public void run(Runnable runnable) {
        this.threadPool.execute(runnable);
    }
}

